/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.StatementMapper;
import software.coley.sourcesolver.model.AbstractModel;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.util.Range;

public class TypeArgumentsMapper
implements Mapper<Args, ArgsTree> {
    @Override
    @Nonnull
    public Args map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nullable ArgsTree tree) {
        List<Model> typeArguments = tree == null || tree.getTypeArguments() == null ? Collections.emptyList() : tree.getTypeArguments().stream().map(t -> {
            Object model;
            if (t instanceof ExpressionTree) {
                ExpressionTree e = (ExpressionTree)t;
                model = context.map(ExpressionMapper.class, e);
            } else if (t instanceof StatementTree) {
                StatementTree s = (StatementTree)t;
                model = context.map(StatementMapper.class, s);
            } else {
                throw new IllegalStateException("Unsupported type argument AST node: " + t.getClass().getSimpleName());
            }
            return model;
        }).toList();
        return new Args(typeArguments);
    }

    public static interface ArgsTree
    extends Tree {
        public List<? extends Tree> getTypeArguments();

        @Override
        default public Tree.Kind getKind() {
            return Tree.Kind.OTHER;
        }

        @Override
        default public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
            return null;
        }
    }

    public static class Args
    extends AbstractModel {
        private final List<Model> arguments;

        public Args(@Nonnull List<Model> arguments) {
            super(Range.UNKNOWN);
            this.arguments = arguments;
        }

        @Nonnull
        public List<Model> getArguments() {
            return this.arguments;
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }
}

