/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.List;
import software.coley.sourcesolver.mapping.AnnotationUseMapper;
import software.coley.sourcesolver.mapping.IdentifierMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.NameMapper;
import software.coley.sourcesolver.mapping.TypeMapper;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.TypeParameterModel;
import software.coley.sourcesolver.util.Range;

public class TypeParameterMapper
implements Mapper<TypeParameterModel, TypeParameterTree> {
    @Override
    @Nonnull
    public TypeParameterModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull TypeParameterTree tree) {
        List<AnnotationExpressionModel> annotationModels = tree.getAnnotations().stream().map(anno -> (AnnotationExpressionModel)context.map(AnnotationUseMapper.class, anno)).toList();
        List<Model> bounds = tree.getBounds().stream().map(b -> {
            if (b instanceof IdentifierTree) {
                IdentifierTree identifier = (IdentifierTree)b;
                return context.map(IdentifierMapper.class, identifier);
            }
            if (b instanceof ParameterizedTypeTree) {
                ParameterizedTypeTree parameterizedType = (ParameterizedTypeTree)b;
                return context.map(TypeMapper.class, parameterizedType);
            }
            return context.map(NameMapper.class, b);
        }).toList();
        String name = tree.getName().toString();
        return new TypeParameterModel(Range.extractRange(table, tree), name, bounds, annotationModels);
    }
}

