/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.ModifiersMapper;
import software.coley.sourcesolver.mapping.TypeMapper;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.ModifiersModel;
import software.coley.sourcesolver.model.TypeModel;
import software.coley.sourcesolver.model.VariableModel;
import software.coley.sourcesolver.util.Range;

public class VariableMapper
implements Mapper<VariableModel, VariableTree> {
    @Override
    @Nonnull
    public VariableModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull VariableTree tree) {
        ModifiersMapper.ModifiersParsePair modifiersPair = (ModifiersMapper.ModifiersParsePair)context.map(ModifiersMapper.class, tree.getModifiers());
        List<AnnotationExpressionModel> annotationModels = modifiersPair.getAnnotations() == null ? Collections.emptyList() : modifiersPair.getAnnotations();
        ModifiersModel modifiers = modifiersPair.isEmpty() ? ModifiersModel.EMPTY : modifiersPair.getModifiers();
        TypeModel typeModel = context.mapOr(TypeMapper.class, tree.getType(), TypeModel::newVar);
        String name = tree.getName().toString();
        ExpressionTree initializer = tree.getInitializer();
        Model valueModel = initializer == null ? null : (Model)context.map(ExpressionMapper.class, initializer);
        return new VariableModel(Range.extractRange(table, tree), annotationModels, modifiers, typeModel, name, valueModel);
    }
}

