/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.resolve.Resolver;
import software.coley.sourcesolver.resolve.result.Resolution;
import software.coley.sourcesolver.util.Range;

public abstract class AbstractModel
implements Model {
    private final List<Model> children;
    private final Range range;
    private Model parent;
    private Resolution resolution;

    protected AbstractModel(@Nonnull Range range) {
        this.range = range;
        this.children = Collections.emptyList();
    }

    protected AbstractModel(@Nonnull Range range, Model ... children) {
        this.range = range;
        this.children = AbstractModel.extractChildren(Arrays.stream(children));
        for (Model child : children) {
            if (!(child instanceof AbstractModel)) continue;
            AbstractModel abstractChild = (AbstractModel)child;
            abstractChild.parent = this;
        }
    }

    protected AbstractModel(@Nonnull Range range, ChildSupplier ... suppliers) {
        this.range = range;
        this.children = AbstractModel.extractChildren(Arrays.stream(suppliers).flatMap(supplier -> supplier.isSingle() ? Stream.of(supplier.getSingle()) : supplier.getMultiple().stream()));
        for (Model child : this.children) {
            if (!(child instanceof AbstractModel)) continue;
            AbstractModel abstractChild = (AbstractModel)child;
            abstractChild.parent = this;
        }
    }

    protected AbstractModel(@Nonnull Range range, @Nonnull Collection<? extends Model> children) {
        this.range = range;
        this.children = AbstractModel.extractChildren(children.stream());
        for (Model model : children) {
            if (!(model instanceof AbstractModel)) continue;
            AbstractModel abstractChild = (AbstractModel)model;
            abstractChild.parent = this;
        }
    }

    @Nonnull
    private static List<Model> extractChildren(@Nonnull Stream<Model> stream) {
        return stream.filter(c -> c != null && !c.getRange().isUnknown()).sorted(Comparator.comparing(Model::getRange)).toList();
    }

    @Override
    @Nonnull
    public Resolution resolveAt(@Nonnull Resolver resolver, int position) {
        if (this.resolution == null) {
            this.resolution = resolver.resolveAt(position, this);
        }
        return this.resolution;
    }

    @Override
    @Nonnull
    public List<Model> getChildren() {
        return this.children;
    }

    @Override
    @Nullable
    public Model getParent() {
        return this.parent;
    }

    @Override
    @Nonnull
    public Range getRange() {
        return this.range;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

