/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AnnotationArgumentModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.NameExpressionModel;
import software.coley.sourcesolver.model.NameHoldingModel;
import software.coley.sourcesolver.util.Range;

public class AnnotationExpressionModel
extends AbstractExpressionModel
implements NameHoldingModel {
    private final NameExpressionModel name;
    private final List<AnnotationArgumentModel> arguments;

    public AnnotationExpressionModel(@Nonnull Range range, @Nonnull NameExpressionModel name, @Nonnull List<AnnotationArgumentModel> arguments) {
        super(range, ChildSupplier.of((Model)name), ChildSupplier.of(arguments));
        this.name = name;
        this.arguments = arguments;
    }

    @Override
    @Nonnull
    public NameExpressionModel getNameModel() {
        return this.name;
    }

    @Nonnull
    public List<AnnotationArgumentModel> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationExpressionModel that = (AnnotationExpressionModel)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.arguments.equals(that.arguments);
    }

    @Override
    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.arguments.hashCode();
        return result;
    }

    public String toString() {
        String display = "@" + String.valueOf(this.name);
        if (!this.arguments.isEmpty()) {
            display = display + "(" + this.arguments.stream().map(AnnotationArgumentModel::toString).collect(Collectors.joining(", ")) + ")";
        }
        return display;
    }
}

