/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.util.Range;

public class AssignmentExpressionModel
extends AbstractExpressionModel {
    private final AbstractExpressionModel variable;
    private final AbstractExpressionModel expression;
    private final Operator operator;

    public AssignmentExpressionModel(@Nonnull Range range, @Nonnull AbstractExpressionModel variable, @Nonnull AbstractExpressionModel expression, @Nonnull Operator operator) {
        super(range, ChildSupplier.of((Model)variable), ChildSupplier.of((Model)expression));
        this.variable = variable;
        this.expression = expression;
        this.operator = operator;
    }

    @Nonnull
    public AbstractExpressionModel getVariable() {
        return this.variable;
    }

    @Nonnull
    public AbstractExpressionModel getExpression() {
        return this.expression;
    }

    @Nonnull
    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignmentExpressionModel that = (AssignmentExpressionModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.variable.equals(that.variable)) {
            return false;
        }
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        return this.operator.equals((Object)that.operator);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.variable.hashCode();
        result = 31 * result + this.expression.hashCode();
        result = 31 * result + this.operator.hashCode();
        return result;
    }

    public String toString() {
        return String.valueOf(this.variable) + " " + String.valueOf((Object)this.operator) + " " + String.valueOf(this.expression);
    }

    public static enum Operator {
        SET("="),
        PLUS("+="),
        MINUS("-="),
        MULTIPLY("*="),
        DIVIDE("/="),
        REMAINDER("%="),
        BIT_OR("|="),
        BIT_AND("&="),
        BIT_XOR("^="),
        SHIFT_LEFT("<<="),
        SHIFT_RIGHT(">>="),
        SHIFT_RIGHT_UNSIGNED(">>>="),
        UNKNOWN("<asignop>");

        private final String text;

        private Operator(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

