/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import software.coley.sourcesolver.model.AbstractStatementModel;
import software.coley.sourcesolver.model.AnnotatedModel;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.ImplementsModel;
import software.coley.sourcesolver.model.MethodModel;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.ModifiersModel;
import software.coley.sourcesolver.model.NameExpressionModel;
import software.coley.sourcesolver.model.NameHoldingModel;
import software.coley.sourcesolver.model.NamedModel;
import software.coley.sourcesolver.model.PermitsModel;
import software.coley.sourcesolver.model.TypeParameterModel;
import software.coley.sourcesolver.model.VariableModel;
import software.coley.sourcesolver.util.Range;

public class ClassModel
extends AbstractStatementModel
implements AnnotatedModel,
NameHoldingModel {
    private final List<AnnotationExpressionModel> annotations;
    private final ModifiersModel modifiers;
    private final String name;
    private final List<TypeParameterModel> typeParameters;
    private final NamedModel extendsModel;
    private final ImplementsModel implementsModel;
    private final PermitsModel permitsModel;
    private final List<VariableModel> fields;
    private final List<MethodModel> methods;
    private final List<ClassModel> innerClasses;

    public ClassModel(@Nonnull Range range, @Nonnull List<AnnotationExpressionModel> annotations, @Nonnull ModifiersModel modifiers, @Nonnull String name, @Nonnull List<TypeParameterModel> typeParameters, @Nonnull NamedModel extendsModel, @Nonnull ImplementsModel implementsModel, @Nonnull PermitsModel permitsModel, @Nonnull List<VariableModel> fields, @Nonnull List<MethodModel> methods, @Nonnull List<ClassModel> innerClasses) {
        super(range, ChildSupplier.of(annotations), ChildSupplier.of(typeParameters), ChildSupplier.of((Model)extendsModel), ChildSupplier.of((Model)implementsModel), ChildSupplier.of((Model)permitsModel), ChildSupplier.of(fields), ChildSupplier.of(methods), ChildSupplier.of(innerClasses));
        this.annotations = Collections.unmodifiableList(annotations);
        this.modifiers = modifiers;
        this.name = name;
        this.typeParameters = typeParameters;
        this.extendsModel = extendsModel;
        this.implementsModel = implementsModel;
        this.permitsModel = permitsModel;
        this.fields = Collections.unmodifiableList(fields);
        this.methods = Collections.unmodifiableList(methods);
        this.innerClasses = Collections.unmodifiableList(innerClasses);
    }

    @Override
    @Nonnull
    public List<AnnotationExpressionModel> getAnnotations() {
        return this.annotations;
    }

    @Nonnull
    public ModifiersModel getModifiers() {
        return this.modifiers;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public List<TypeParameterModel> getTypeParameters() {
        return this.typeParameters;
    }

    @Nonnull
    public NamedModel getExtends() {
        return this.extendsModel;
    }

    @Nonnull
    public ImplementsModel getImplements() {
        return this.implementsModel;
    }

    @Nonnull
    public PermitsModel getPermits() {
        return this.permitsModel;
    }

    @Override
    @Nullable
    public NameExpressionModel getNameModel() {
        return null;
    }

    @Nonnull
    public List<VariableModel> getFields() {
        return this.fields;
    }

    @Nonnull
    public List<MethodModel> getMethods() {
        return this.methods;
    }

    @Nonnull
    public List<ClassModel> getInnerClasses() {
        return this.innerClasses;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassModel that = (ClassModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.annotations.equals(that.annotations)) {
            return false;
        }
        if (!this.modifiers.equals(that.modifiers)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.typeParameters.equals(that.typeParameters)) {
            return false;
        }
        if (!this.extendsModel.equals(that.extendsModel)) {
            return false;
        }
        if (!this.implementsModel.equals(that.implementsModel)) {
            return false;
        }
        if (!this.permitsModel.equals(that.permitsModel)) {
            return false;
        }
        if (!this.fields.equals(that.fields)) {
            return false;
        }
        if (!this.methods.equals(that.methods)) {
            return false;
        }
        return this.innerClasses.equals(that.innerClasses);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.annotations.hashCode();
        result = 31 * result + this.modifiers.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.typeParameters.hashCode();
        result = 31 * result + this.extendsModel.hashCode();
        result = 31 * result + this.implementsModel.hashCode();
        result = 31 * result + this.permitsModel.hashCode();
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + this.methods.hashCode();
        result = 31 * result + this.innerClasses.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("class ").append(this.name);
        if (this.fields.isEmpty() && this.methods.isEmpty()) {
            sb.append(" {}");
        } else {
            sb.append(" {\n    // Fields");
            for (VariableModel fieldModel : this.fields) {
                sb.append("\n    ").append(fieldModel.toString());
            }
            sb.append("\n    // Methods");
            for (MethodModel methodModel : this.methods) {
                sb.append("\n    ").append(methodModel.toString());
            }
            sb.append("\n}");
        }
        return sb.toString();
    }
}

