/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.util.Range;

public class ConditionalExpressionModel
extends AbstractExpressionModel {
    private final AbstractExpressionModel condition;
    private final AbstractExpressionModel trueCase;
    private final AbstractExpressionModel falseCase;

    public ConditionalExpressionModel(@Nonnull Range range, @Nonnull AbstractExpressionModel condition, @Nonnull AbstractExpressionModel trueCase, @Nonnull AbstractExpressionModel falseCase) {
        super(range, condition, trueCase, falseCase);
        this.condition = condition;
        this.trueCase = trueCase;
        this.falseCase = falseCase;
    }

    @Nonnull
    public AbstractExpressionModel getCondition() {
        return this.condition;
    }

    @Nonnull
    public AbstractExpressionModel getTrueCase() {
        return this.trueCase;
    }

    @Nonnull
    public AbstractExpressionModel getFalseCase() {
        return this.falseCase;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalExpressionModel that = (ConditionalExpressionModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.condition.equals(that.condition)) {
            return false;
        }
        if (!this.trueCase.equals(that.trueCase)) {
            return false;
        }
        return this.falseCase.equals(that.falseCase);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.condition.hashCode();
        result = 31 * result + this.trueCase.hashCode();
        result = 31 * result + this.falseCase.hashCode();
        return result;
    }

    public String toString() {
        return String.valueOf(this.condition) + " ? " + String.valueOf(this.trueCase) + " : " + String.valueOf(this.falseCase);
    }
}

