/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AbstractStatementModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.util.Range;

public class IfStatementModel
extends AbstractStatementModel {
    private final AbstractExpressionModel condition;
    private final AbstractStatementModel thenCaseStatement;
    private final AbstractStatementModel elseCaseStatement;

    public IfStatementModel(@Nonnull Range range, @Nonnull AbstractExpressionModel condition, @Nonnull AbstractStatementModel thenCaseStatement, @Nullable AbstractStatementModel elseCaseStatement) {
        super(range, ChildSupplier.of((Model)condition), ChildSupplier.of((Model)thenCaseStatement), ChildSupplier.of((Model)elseCaseStatement));
        this.condition = condition;
        this.thenCaseStatement = thenCaseStatement;
        this.elseCaseStatement = elseCaseStatement;
    }

    @Nonnull
    public AbstractExpressionModel getCondition() {
        return this.condition;
    }

    @Nonnull
    public AbstractStatementModel getThenCaseStatement() {
        return this.thenCaseStatement;
    }

    @Nullable
    public AbstractStatementModel getElseCaseStatement() {
        return this.elseCaseStatement;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IfStatementModel that = (IfStatementModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.condition.equals(that.condition)) {
            return false;
        }
        if (!this.thenCaseStatement.equals(that.thenCaseStatement)) {
            return false;
        }
        return Objects.equals(this.elseCaseStatement, that.elseCaseStatement);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.condition.hashCode();
        result = 31 * result + this.thenCaseStatement.hashCode();
        result = 31 * result + (this.elseCaseStatement != null ? this.elseCaseStatement.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("if (").append(this.condition.toString()).append(") { ").append(this.thenCaseStatement.toString()).append(" }");
        if (this.elseCaseStatement != null) {
            sb.append(" else ").append(this.elseCaseStatement);
        }
        return sb.toString();
    }
}

