/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AbstractPatternModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.util.Range;

public class InstanceofExpressionModel
extends AbstractExpressionModel {
    private final AbstractExpressionModel expression;
    private final Model type;
    private final AbstractPatternModel pattern;

    public InstanceofExpressionModel(@Nonnull Range range, @Nonnull AbstractExpressionModel expression, @Nonnull Model type, @Nullable AbstractPatternModel pattern) {
        super(range, ChildSupplier.of((Model)expression), ChildSupplier.of(type), ChildSupplier.of((Model)pattern));
        this.expression = expression;
        this.type = type;
        this.pattern = pattern;
    }

    @Nonnull
    public AbstractExpressionModel getExpression() {
        return this.expression;
    }

    @Nonnull
    public Model getType() {
        return this.type;
    }

    @Nullable
    public AbstractPatternModel getPattern() {
        return this.pattern;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstanceofExpressionModel that = (InstanceofExpressionModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return Objects.equals(this.pattern, that.pattern);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.expression.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.pattern != null ? this.pattern.hashCode() : 0);
        return result;
    }

    public String toString() {
        String s = String.valueOf(this.expression) + " instanceof " + String.valueOf(this.type);
        if (this.pattern != null) {
            s = s + " " + String.valueOf(this.pattern);
        }
        return s;
    }
}

