/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import software.coley.sourcesolver.model.AbstractStatementModel;
import software.coley.sourcesolver.util.Range;

public class LabeledStatementModel
extends AbstractStatementModel {
    private final String labelName;
    private final AbstractStatementModel statement;

    public LabeledStatementModel(@Nonnull Range range, @Nullable String labelName, @Nonnull AbstractStatementModel statement) {
        super(range, statement);
        this.labelName = labelName;
        this.statement = statement;
    }

    @Nullable
    public String getLabelName() {
        return this.labelName;
    }

    @Nonnull
    public AbstractStatementModel getStatement() {
        return this.statement;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabeledStatementModel that = (LabeledStatementModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!Objects.equals(this.labelName, that.labelName)) {
            return false;
        }
        return this.statement.equals(that.statement);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + (this.labelName != null ? this.labelName.hashCode() : 0);
        result = 31 * result + this.statement.hashCode();
        return result;
    }

    public String toString() {
        if (this.labelName == null) {
            return "<nameless> { " + String.valueOf(this.statement) + " }";
        }
        return this.labelName + " { " + String.valueOf(this.statement) + " }";
    }
}

