/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.VariableModel;
import software.coley.sourcesolver.util.Range;

public class LambdaExpressionModel
extends AbstractExpressionModel {
    private final List<VariableModel> parameters;
    private final Model body;
    private final BodyKind bodyKind;

    public LambdaExpressionModel(@Nonnull Range range, @Nonnull List<VariableModel> parameters, @Nonnull Model body, @Nonnull BodyKind bodyKind) {
        super(range, ChildSupplier.of(parameters), ChildSupplier.of(body));
        this.parameters = parameters;
        this.body = body;
        this.bodyKind = bodyKind;
    }

    @Nonnull
    public List<VariableModel> getParameters() {
        return this.parameters;
    }

    @Nonnull
    public Model getBody() {
        return this.body;
    }

    @Nonnull
    public BodyKind getBodyKind() {
        return this.bodyKind;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LambdaExpressionModel that = (LambdaExpressionModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        if (!this.body.equals(that.body)) {
            return false;
        }
        return this.bodyKind == that.bodyKind;
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + this.body.hashCode();
        result = 31 * result + this.bodyKind.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(this.parameters.stream().map(Object::toString).collect(Collectors.joining(", "))).append(')');
        sb.append(" -> ");
        switch (this.bodyKind.ordinal()) {
            case 0: {
                sb.append(this.body);
                break;
            }
            case 1: {
                sb.append('{').append(this.body).append('}');
            }
        }
        return sb.toString();
    }

    public static enum BodyKind {
        EXPRESSION,
        STATEMENT;

    }
}

