/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import software.coley.sourcesolver.model.CompilationUnitModel;
import software.coley.sourcesolver.model.ModelVisitor;
import software.coley.sourcesolver.resolve.Resolver;
import software.coley.sourcesolver.resolve.result.Resolution;
import software.coley.sourcesolver.util.Range;

public interface Model {
    @Nonnull
    default public Resolution resolve(@Nonnull Resolver resolver) {
        Range range = this.getRange();
        if (range.isUnknown()) {
            return this.resolveAt(resolver, -1);
        }
        Model parent = this.getParent();
        int index = range.begin();
        if (index < 0 && parent != null) {
            index = parent.getRange().begin();
        }
        return this.resolveAt(resolver, index);
    }

    @Nonnull
    public Resolution resolveAt(@Nonnull Resolver var1, int var2);

    default public void visit(@Nonnull ModelVisitor visitor) {
        if (visitor.visit(this)) {
            for (Model child : this.getChildren()) {
                child.visit(visitor);
            }
        }
    }

    @Nullable
    default public Model getChildAtPosition(int position) {
        for (Model child : this.getChildren()) {
            if (!child.getRange().isWithin(position)) continue;
            return child;
        }
        return null;
    }

    @Nonnull
    default public <M extends Model> List<M> getRecursiveChildrenOfType(@Nonnull Class<M> type) {
        ArrayList models = new ArrayList();
        this.visit(child -> {
            if (type.isAssignableFrom(child.getClass())) {
                models.add(child);
            }
            return true;
        });
        return models;
    }

    @Nullable
    default public <M extends Model> M getParentOfType(@Nonnull Class<M> type) {
        for (Model parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!type.isAssignableFrom(parent.getClass())) continue;
            return (M)parent;
        }
        return null;
    }

    default public boolean isParentOf(@Nonnull Model model) {
        return model.isChildOf(this);
    }

    default public boolean isChildOf(@Nonnull Model model) {
        for (Model parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != model) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    default public String getSource(@Nonnull CompilationUnitModel unit) {
        Range range = this.getRange();
        if (range.isUnknown()) {
            return "";
        }
        String src = unit.getInputSource();
        int begin = Math.max(0, range.begin());
        int end = Math.min(src.length(), range.end());
        return src.substring(begin, end);
    }

    @Nonnull
    public List<Model> getChildren();

    @Nullable
    public Model getParent();

    @Nonnull
    public Range getRange();
}

