/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import software.coley.sourcesolver.model.AbstractModel;
import software.coley.sourcesolver.model.AnnotatedModel;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.NameExpressionModel;
import software.coley.sourcesolver.model.NameHoldingModel;
import software.coley.sourcesolver.util.Range;

public class PackageModel
extends AbstractModel
implements AnnotatedModel,
NameHoldingModel {
    public static final PackageModel DEFAULT_PACKAGE = new PackageModel(Range.UNKNOWN, new NameExpressionModel(Range.UNKNOWN, ""), Collections.emptyList());
    private final NameExpressionModel name;
    private final List<AnnotationExpressionModel> annotations;

    public PackageModel(@Nonnull Range range, @Nonnull NameExpressionModel name, @Nonnull List<AnnotationExpressionModel> annotations) {
        super(range, ChildSupplier.of((Model)name), ChildSupplier.of(annotations));
        this.name = name;
        this.annotations = annotations;
    }

    public boolean isDefaultPackage() {
        return this.name.getName().isEmpty() && this.annotations.isEmpty();
    }

    @Override
    @Nonnull
    public List<AnnotationExpressionModel> getAnnotations() {
        return this.annotations;
    }

    @Override
    @Nonnull
    public NameExpressionModel getNameModel() {
        return this.name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageModel that = (PackageModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.annotations.equals(that.annotations);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.annotations.hashCode();
        return result;
    }

    public String toString() {
        return "package " + this.name.getName();
    }
}

