/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.NamedModel;
import software.coley.sourcesolver.util.Range;

public class PermitsModel
extends AbstractModel {
    public static final PermitsModel EMPTY = new PermitsModel(Range.UNKNOWN, Collections.emptyList());
    private final List<NamedModel> permittedClassNames;

    public PermitsModel(@Nonnull Range range, @Nonnull List<NamedModel> permittedClassNames) {
        super(range, ChildSupplier.of(permittedClassNames));
        this.permittedClassNames = Collections.unmodifiableList(permittedClassNames);
    }

    @Nonnull
    public List<NamedModel> getPermittedClassNames() {
        return this.permittedClassNames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermitsModel that = (PermitsModel)o;
        return this.permittedClassNames.equals(that.permittedClassNames) && this.getRange().equals(that.getRange());
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.permittedClassNames.hashCode();
        return result;
    }

    public String toString() {
        if (this.permittedClassNames.isEmpty()) {
            return "";
        }
        return "permits " + this.permittedClassNames.stream().map(NamedModel::getName).collect(Collectors.joining(", "));
    }
}

