/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AbstractStatementModel;
import software.coley.sourcesolver.model.BlockStatementModel;
import software.coley.sourcesolver.util.Range;

public class SynchronizedStatementModel
extends AbstractStatementModel {
    private final AbstractExpressionModel expression;
    private final BlockStatementModel block;

    public SynchronizedStatementModel(@Nonnull Range range, @Nonnull AbstractExpressionModel expression, @Nonnull BlockStatementModel block) {
        super(range);
        this.expression = expression;
        this.block = block;
    }

    @Nonnull
    public AbstractExpressionModel getExpression() {
        return this.expression;
    }

    @Nonnull
    public BlockStatementModel getBlock() {
        return this.block;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SynchronizedStatementModel that = (SynchronizedStatementModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        return this.block.equals(that.block);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.expression.hashCode();
        result = 31 * result + this.block.hashCode();
        return result;
    }

    public String toString() {
        return "synchronized (" + String.valueOf(this.expression) + ") " + String.valueOf(this.block);
    }
}

