/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractStatementModel;
import software.coley.sourcesolver.model.BlockStatementModel;
import software.coley.sourcesolver.model.CatchModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.util.Range;

public class TryStatementModel
extends AbstractStatementModel {
    private final BlockStatementModel block;
    private final BlockStatementModel finallyBlock;
    private final List<Model> resources;
    private final List<CatchModel> catches;

    public TryStatementModel(@Nonnull Range range, @Nonnull BlockStatementModel block, @Nullable BlockStatementModel finallyBlock, @Nonnull List<Model> resources, @Nonnull List<CatchModel> catches) {
        super(range, ChildSupplier.of((Model)block), ChildSupplier.of((Model)finallyBlock), ChildSupplier.of(resources), ChildSupplier.of(catches));
        this.block = block;
        this.finallyBlock = finallyBlock;
        this.resources = resources;
        this.catches = catches;
    }

    @Nonnull
    public BlockStatementModel getBlock() {
        return this.block;
    }

    @Nullable
    public BlockStatementModel getFinallyBlock() {
        return this.finallyBlock;
    }

    @Nonnull
    public List<Model> getResources() {
        return this.resources;
    }

    @Nonnull
    public List<CatchModel> getCatches() {
        return this.catches;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TryStatementModel that = (TryStatementModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.block.equals(that.block)) {
            return false;
        }
        if (!Objects.equals(this.finallyBlock, that.finallyBlock)) {
            return false;
        }
        if (!this.resources.equals(that.resources)) {
            return false;
        }
        return this.catches.equals(that.catches);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.block.hashCode();
        result = 31 * result + (this.finallyBlock != null ? this.finallyBlock.hashCode() : 0);
        result = 31 * result + this.resources.hashCode();
        result = 31 * result + this.catches.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.resources.isEmpty()) {
            sb.append("try ");
        } else {
            sb.append("try (").append(this.resources.stream().map(Object::toString).collect(Collectors.joining("; "))).append(")");
        }
        sb.append(this.block).append('\n').append(this.catches.stream().map(CatchModel::toString).collect(Collectors.joining("\n")));
        if (this.finallyBlock != null) {
            sb.append(this.finallyBlock);
        }
        return sb.toString();
    }
}

