/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.resolve.entry;

import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.resolve.entry.ArrayEntry;
import software.coley.sourcesolver.resolve.entry.DescribableEntry;

public class BasicArrayEntry
implements ArrayEntry {
    private final int dimensions;
    private final DescribableEntry elementEntry;

    public BasicArrayEntry(int dimensions, @Nonnull DescribableEntry elementEntry) {
        this.dimensions = dimensions;
        this.elementEntry = elementEntry;
    }

    @Override
    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    @Nonnull
    public DescribableEntry getElementEntry() {
        return this.elementEntry;
    }

    @Override
    @Nonnull
    public String getDescriptor() {
        return "[".repeat(this.dimensions) + this.elementEntry.getDescriptor();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicArrayEntry that = (BasicArrayEntry)o;
        if (this.dimensions != that.dimensions) {
            return false;
        }
        return this.elementEntry.equals(that.elementEntry);
    }

    public int hashCode() {
        int result = this.dimensions;
        result = 31 * result + this.elementEntry.hashCode();
        return result;
    }

    public String toString() {
        return this.getDescriptor();
    }
}

