/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.resolve.entry;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import software.coley.sourcesolver.resolve.entry.ClassEntry;
import software.coley.sourcesolver.resolve.entry.FieldEntry;
import software.coley.sourcesolver.resolve.entry.MethodEntry;

public class BasicClassEntry
implements ClassEntry {
    private final String className;
    private final int access;
    private final ClassEntry superEntry;
    private final List<ClassEntry> interfaceEntries;
    private final List<ClassEntry> innerClassEntries;
    private final List<FieldEntry> fields;
    private final List<MethodEntry> methods;

    public BasicClassEntry(@Nonnull String className, int access, @Nullable ClassEntry superEntry, @Nonnull List<ClassEntry> interfaceEntries, @Nonnull List<ClassEntry> innerClassEntries, @Nonnull List<FieldEntry> fields, @Nonnull List<MethodEntry> methods) {
        this.className = className;
        this.access = access;
        this.superEntry = superEntry;
        this.interfaceEntries = interfaceEntries;
        this.innerClassEntries = innerClassEntries;
        this.fields = fields;
        this.methods = methods;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.className;
    }

    @Override
    public int getAccess() {
        return this.access;
    }

    @Override
    @Nullable
    public ClassEntry getSuperEntry() {
        return this.superEntry;
    }

    @Override
    @Nonnull
    public List<ClassEntry> getImplementedEntries() {
        return this.interfaceEntries;
    }

    @Override
    @Nonnull
    public List<ClassEntry> getInnerClassEntries() {
        return this.innerClassEntries;
    }

    @Override
    @Nonnull
    public List<FieldEntry> getDeclaredFields() {
        return this.fields;
    }

    @Override
    @Nonnull
    public List<MethodEntry> getDeclaredMethods() {
        return this.methods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicClassEntry that = (BasicClassEntry)o;
        if (this.access != that.access) {
            return false;
        }
        if (!this.className.equals(that.className)) {
            return false;
        }
        if (!Objects.equals(this.superEntry, that.superEntry)) {
            return false;
        }
        if (!this.interfaceEntries.equals(that.interfaceEntries)) {
            return false;
        }
        if (!this.innerClassEntries.equals(that.innerClassEntries)) {
            return false;
        }
        if (!this.fields.equals(that.fields)) {
            return false;
        }
        return this.methods.equals(that.methods);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = 31 * result + this.access;
        result = 31 * result + (this.superEntry != null ? this.superEntry.hashCode() : 0);
        result = 31 * result + this.interfaceEntries.hashCode();
        result = 31 * result + this.innerClassEntries.hashCode();
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + this.methods.hashCode();
        return result;
    }

    public String toString() {
        return this.getName();
    }
}

