/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.resolve.entry;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import software.coley.sourcesolver.resolve.entry.ClassEntry;
import software.coley.sourcesolver.resolve.entry.EntryPool;

public class BasicEntryPool
implements EntryPool {
    private final Map<String, ClassEntry> classEntries = new HashMap<String, ClassEntry>();

    @Override
    public void register(@Nonnull ClassEntry entry) {
        this.classEntries.put(entry.getName(), entry);
    }

    @Override
    @Nullable
    public ClassEntry getClass(@Nonnull String name) {
        return this.classEntries.get(name);
    }

    @Override
    @Nonnull
    public List<ClassEntry> getClassesInPackage(@Nullable String packageName) {
        ArrayList<ClassEntry> entries = new ArrayList<ClassEntry>();
        if (packageName == null) {
            for (ClassEntry entry : this.classEntries.values()) {
                if (entry.getName().indexOf(47) >= 0) continue;
                entries.add(entry);
            }
        } else {
            int packageNameLength = packageName.length();
            for (ClassEntry entry : this.classEntries.values()) {
                String entryName = entry.getName();
                if (!entryName.startsWith(packageName) || entryName.lastIndexOf(47) != packageNameLength) continue;
                entries.add(entry);
            }
        }
        return entries;
    }
}

