/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.resolve.entry;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import software.coley.sourcesolver.resolve.entry.AccessedEntry;
import software.coley.sourcesolver.resolve.entry.DescribableEntry;
import software.coley.sourcesolver.resolve.entry.FieldEntry;
import software.coley.sourcesolver.resolve.entry.MemberEntry;
import software.coley.sourcesolver.resolve.entry.MethodEntry;
import software.coley.sourcesolver.resolve.entry.NullEntry;

public non-sealed interface ClassEntry
extends AccessedEntry,
DescribableEntry {
    @Nullable
    public ClassEntry getSuperEntry();

    @Nonnull
    public List<ClassEntry> getImplementedEntries();

    @Nonnull
    public List<ClassEntry> getInnerClassEntries();

    @Nonnull
    public String getName();

    @Nullable
    default public String getPackageName() {
        String name = this.getName();
        int i = name.lastIndexOf(47);
        if (i < 0) {
            return null;
        }
        return name.substring(0, i);
    }

    @Override
    @Nonnull
    default public String getDescriptor() {
        return "L" + this.getName() + ";";
    }

    default public boolean isInterface() {
        return (this.getAccess() & 0x200) != 0;
    }

    @Nonnull
    public List<FieldEntry> getDeclaredFields();

    @Nonnull
    public List<MethodEntry> getDeclaredMethods();

    @Nonnull
    default public Stream<MemberEntry> declaredMemberStream() {
        return Stream.concat(this.getDeclaredFields().stream(), this.getDeclaredMethods().stream());
    }

    @Nullable
    default public FieldEntry getField(@Nonnull String name, @Nonnull String desc) {
        return this.getField(name, desc, null);
    }

    @Nullable
    default public FieldEntry getField(@Nonnull String name, @Nonnull String desc, @Nullable Predicate<FieldEntry> filter) {
        FieldEntry superField;
        FieldEntry field = this.getDeclaredField(name, desc, filter);
        if (field != null) {
            return field;
        }
        ClassEntry superEntry = this.getSuperEntry();
        if (superEntry != null && (superField = superEntry.getField(name, desc, m -> !m.isPrivate())) != null) {
            return superField;
        }
        for (ClassEntry implementedEntry : this.getImplementedEntries()) {
            FieldEntry superField2 = implementedEntry.getField(name, desc, m -> !m.isPrivate());
            if (superField2 == null) continue;
            return superField2;
        }
        return null;
    }

    @Nullable
    default public FieldEntry getDeclaredField(@Nonnull String name, @Nonnull String desc) {
        return this.getDeclaredField(name, desc, null);
    }

    @Nullable
    default public FieldEntry getDeclaredField(@Nonnull String name, @Nonnull String desc, @Nullable Predicate<FieldEntry> filter) {
        for (FieldEntry field : this.getDeclaredFields()) {
            if (!field.getName().equals(name) || !field.getDescriptor().equals(desc) || filter != null && !filter.test(field)) continue;
            return field;
        }
        return null;
    }

    @Nonnull
    default public List<FieldEntry> getDeclaredFieldsByName(@Nonnull String name) {
        ArrayList<FieldEntry> matched = new ArrayList<FieldEntry>();
        for (FieldEntry field : this.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            matched.add(field);
        }
        return matched;
    }

    @Nullable
    default public MethodEntry getMethod(@Nonnull String name, @Nonnull String desc) {
        return this.getMethod(name, desc, null);
    }

    @Nullable
    default public MethodEntry getMethod(@Nonnull String name, @Nonnull String desc, @Nullable Predicate<MethodEntry> filter) {
        MethodEntry superMethod;
        MethodEntry method = this.getDeclaredMethod(name, desc, filter);
        if (method != null) {
            return method;
        }
        ClassEntry superEntry = this.getSuperEntry();
        if (superEntry != null && (superMethod = superEntry.getMethod(name, desc, m -> !m.isPrivate())) != null) {
            return superMethod;
        }
        for (ClassEntry implementedEntry : this.getImplementedEntries()) {
            MethodEntry superMethod2 = implementedEntry.getMethod(name, desc, m -> !m.isPrivate());
            if (superMethod2 == null) continue;
            return superMethod2;
        }
        return null;
    }

    @Nullable
    default public MethodEntry getDeclaredMethod(@Nonnull String name, @Nonnull String desc) {
        return this.getDeclaredMethod(name, desc, null);
    }

    @Nullable
    default public MethodEntry getDeclaredMethod(@Nonnull String name, @Nonnull String desc, @Nullable Predicate<MethodEntry> filter) {
        for (MethodEntry method : this.getDeclaredMethods()) {
            if (!method.getName().equals(name) || !method.getDescriptor().equals(desc) || filter != null && !filter.test(method)) continue;
            return method;
        }
        return null;
    }

    @Nonnull
    default public List<MethodEntry> getDeclaredMethodsByName(@Nonnull String name) {
        ArrayList<MethodEntry> matched = new ArrayList<MethodEntry>();
        for (MethodEntry method : this.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            matched.add(method);
        }
        return matched;
    }

    default public void visitHierarchy(@Nonnull Consumer<ClassEntry> consumer) {
        consumer.accept(this);
        ClassEntry superEntry = this.getSuperEntry();
        if (superEntry != null) {
            superEntry.visitHierarchy(consumer);
        }
        for (ClassEntry implementedEntry : this.getImplementedEntries()) {
            implementedEntry.visitHierarchy(consumer);
        }
    }

    default public boolean extendsOrImplementsName(@Nonnull String name) {
        if (this.getName().equals(name)) {
            return true;
        }
        if (this.getSuperEntry() != null && this.getSuperEntry().extendsOrImplementsName(name)) {
            return true;
        }
        for (ClassEntry implementedEntry : this.getImplementedEntries()) {
            if (!implementedEntry.extendsOrImplementsName(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean isAssignableFrom(@Nonnull DescribableEntry other) {
        if (other instanceof NullEntry) {
            return true;
        }
        if (other instanceof ClassEntry) {
            ClassEntry otherClass = (ClassEntry)other;
            return this.isAssignableFrom(otherClass);
        }
        return false;
    }

    default public boolean isAssignableFrom(@Nonnull ClassEntry child) {
        if (Objects.equals(this.getName(), child.getName()) || this.getName().equals("java/lang/Object")) {
            return true;
        }
        ClassEntry superEntry = child.getSuperEntry();
        if (superEntry != null && this.isAssignableFrom(superEntry)) {
            return true;
        }
        for (ClassEntry implementedEntry : child.getImplementedEntries()) {
            if (!this.isAssignableFrom(implementedEntry)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    default public ClassEntry getCommonParent(@Nonnull ClassEntry other) {
        if (this.isAssignableFrom(other)) {
            return this;
        }
        if (other.isAssignableFrom(this)) {
            return other;
        }
        if (this.isInterface() || other.isInterface()) {
            while (!other.getName().equals("java/lang/Object")) {
                if ((other = other.getSuperEntry()) != null) continue;
                throw new IllegalStateException("Object not found in class hierarchy");
            }
            return other;
        }
        ClassEntry superEntry = this.getSuperEntry();
        if (superEntry != null) {
            return superEntry.getCommonParent(other);
        }
        throw new IllegalStateException("Could not compute common parent, did not observe 'java/lang/Object' boundary");
    }
}

