/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.resolve.entry;

import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.resolve.entry.BasicPrimitiveEntry;
import software.coley.sourcesolver.resolve.entry.DescribableEntry;

public non-sealed interface PrimitiveEntry
extends DescribableEntry {
    public static final PrimitiveEntry VOID = new BasicPrimitiveEntry(Kind.VOID, "V");
    public static final PrimitiveEntry BOOLEAN = new BasicPrimitiveEntry(Kind.BOOLEAN, "Z");
    public static final PrimitiveEntry CHAR = new BasicPrimitiveEntry(Kind.CHAR, "C");
    public static final PrimitiveEntry BYTE = new BasicPrimitiveEntry(Kind.BYTE, "B");
    public static final PrimitiveEntry SHORT = new BasicPrimitiveEntry(Kind.SHORT, "S");
    public static final PrimitiveEntry INT = new BasicPrimitiveEntry(Kind.INT, "I");
    public static final PrimitiveEntry FLOAT = new BasicPrimitiveEntry(Kind.FLOAT, "F");
    public static final PrimitiveEntry LONG = new BasicPrimitiveEntry(Kind.LONG, "J");
    public static final PrimitiveEntry DOUBLE = new BasicPrimitiveEntry(Kind.DOUBLE, "D");

    @Nonnull
    public static PrimitiveEntry getPrimitive(@Nonnull String descriptor) {
        if (descriptor.length() != 1) {
            throw new IllegalStateException("Not a primitive descriptor: " + descriptor);
        }
        return switch (descriptor.charAt(0)) {
            case 'Z' -> BOOLEAN;
            case 'B' -> BYTE;
            case 'S' -> SHORT;
            case 'I' -> INT;
            case 'J' -> LONG;
            case 'C' -> CHAR;
            case 'F' -> FLOAT;
            case 'D' -> DOUBLE;
            case 'V' -> VOID;
            default -> throw new IllegalStateException("Invalid primitive descriptor: " + descriptor);
        };
    }

    @Override
    default public boolean isAssignableFrom(@Nonnull DescribableEntry other) {
        if (other instanceof PrimitiveEntry) {
            PrimitiveEntry otherPrimitive = (PrimitiveEntry)other;
            return this.isAssignableFrom(otherPrimitive);
        }
        return false;
    }

    default public boolean isAssignableFrom(@Nonnull PrimitiveEntry other) {
        return this.getKind().ordinal() >= other.getKind().ordinal();
    }

    @Nonnull
    public Kind getKind();

    public static enum Kind {
        VOID,
        BOOLEAN,
        CHAR,
        BYTE,
        SHORT,
        INT,
        FLOAT,
        LONG,
        DOUBLE;

    }
}

