/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.resolve.entry;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.stream.Collectors;
import software.coley.sourcesolver.resolve.entry.AccessedEntry;
import software.coley.sourcesolver.resolve.entry.ClassEntry;
import software.coley.sourcesolver.resolve.entry.FieldEntry;
import software.coley.sourcesolver.resolve.entry.MethodEntry;

public class StaticFilteredClassEntry
implements ClassEntry {
    private final ClassEntry delegate;

    public StaticFilteredClassEntry(@Nonnull ClassEntry delegate) {
        this.delegate = delegate;
    }

    @Override
    public int getAccess() {
        return this.delegate.getAccess();
    }

    @Override
    @Nullable
    public ClassEntry getSuperEntry() {
        ClassEntry superEntry = this.delegate.getSuperEntry();
        if (superEntry == null) {
            return null;
        }
        return new StaticFilteredClassEntry(superEntry);
    }

    @Override
    @Nonnull
    public List<ClassEntry> getImplementedEntries() {
        return this.delegate.getImplementedEntries().stream().map(StaticFilteredClassEntry::new).toList();
    }

    @Override
    @Nonnull
    public List<ClassEntry> getInnerClassEntries() {
        return this.delegate.getInnerClassEntries();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    @Nonnull
    public List<FieldEntry> getDeclaredFields() {
        return this.delegate.getDeclaredFields().stream().filter(AccessedEntry::isStatic).collect(Collectors.toList());
    }

    @Override
    @Nonnull
    public List<MethodEntry> getDeclaredMethods() {
        return this.delegate.getDeclaredMethods().stream().filter(AccessedEntry::isStatic).collect(Collectors.toList());
    }
}

