/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.Field;
import javax.tools.JavaFileManager;
import software.coley.sourcesolver.ErrorIgnoringLog;
import software.coley.sourcesolver.NoopFileManager;
import software.coley.sourcesolver.mapping.CompilationUnitMapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.MappingContextProvider;
import software.coley.sourcesolver.model.CompilationUnitModel;

public class Parser {
    private Context context;
    private ParserFactory factory;
    private MappingContextProvider mappingContextFactory = MappingContext::new;

    public Parser() {
        this.context = new Context();
        this.context.put(JavaFileManager.class, new NoopFileManager());
        this.context.put(Log.logKey, new ErrorIgnoringLog(this.context));
        this.regenerateFactory();
    }

    public void setMappingContextFactory(@Nonnull MappingContextProvider mappingContextFactory) {
        this.mappingContextFactory = mappingContextFactory;
    }

    public void setJavacContext(@Nonnull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Cannot assign a 'null' context!");
        }
        this.context = context;
        this.regenerateFactory();
    }

    @Nullable
    public <T> T getContextProperty(@Nonnull Class<T> key) {
        return this.context.get(key);
    }

    public <T> void putContextProperty(@Nonnull Class<T> key, @Nonnull T value) {
        this.context.put(key, value);
    }

    public <T> void putContextProperty(@Nonnull Class<T> key, @Nonnull Context.Factory<T> factory) {
        this.context.put(key, factory);
    }

    protected void regenerateFactory() {
        this.factory = ParserFactory.instance(this.context);
    }

    @Nonnull
    public CompilationUnitModel parse(@Nonnull String source) {
        EndPosTable table;
        if (source == null) {
            throw new IllegalArgumentException("Must provide source to parse");
        }
        JavacParser parser = this.factory.newParser(source, false, true, false);
        try {
            table = this.extractEndPosTable(parser);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to extract end-pos table from javac parser", ex);
        }
        JCTree.JCCompilationUnit unit = parser.parseCompilationUnit();
        return this.mapCompilationUnit(source, table, unit);
    }

    @Nonnull
    protected CompilationUnitModel mapCompilationUnit(@Nonnull String source, @Nonnull EndPosTable table, @Nonnull CompilationUnitTree unit) {
        MappingContext mappingContext = this.mappingContextFactory.newMappingContext(table, source);
        mappingContext.setMapperSupplier(CompilationUnitMapper.class, () -> new CompilationUnitMapper(source));
        return (CompilationUnitModel)mappingContext.map(CompilationUnitMapper.class, unit);
    }

    @Nonnull
    protected EndPosTable extractEndPosTable(@Nonnull JavacParser parser) throws Exception {
        Field field = JavacParser.class.getDeclaredField("endPosTable");
        field.setAccessible(true);
        return (EndPosTable)field.get(parser);
    }
}

