/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.NameMapper;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AnnotationArgumentModel;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.NameExpressionModel;
import software.coley.sourcesolver.util.Range;

public class AnnotationUseMapper
implements Mapper<AnnotationExpressionModel, AnnotationTree> {
    @Override
    @Nonnull
    public AnnotationExpressionModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull AnnotationTree tree) {
        Tree annotationType = tree.getAnnotationType();
        List<? extends ExpressionTree> arguments = tree.getArguments();
        ArrayList<AnnotationArgumentModel> argumentModels = new ArrayList<AnnotationArgumentModel>(arguments.size());
        for (ExpressionTree expressionTree : arguments) {
            if (expressionTree instanceof AssignmentTree) {
                AssignmentTree argumentAssign = (AssignmentTree)expressionTree;
                NameExpressionModel nameModel = (NameExpressionModel)context.map(NameMapper.class, argumentAssign.getVariable());
                AbstractExpressionModel valueModel = (AbstractExpressionModel)context.map(ExpressionMapper.class, argumentAssign.getExpression());
                argumentModels.add(new AnnotationArgumentModel(Range.extractRange(table, expressionTree), nameModel, valueModel));
                continue;
            }
            AbstractExpressionModel valueModel = (AbstractExpressionModel)context.map(ExpressionMapper.class, expressionTree);
            argumentModels.add(new AnnotationArgumentModel(Range.extractRange(table, expressionTree), null, valueModel));
        }
        NameExpressionModel name = (NameExpressionModel)context.map(NameMapper.class, annotationType);
        return new AnnotationExpressionModel(Range.extractRange(table, tree), name, argumentModels);
    }
}

