/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.NewArrayTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import software.coley.sourcesolver.mapping.AnnotationUseMapper;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.TypeMapper;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.ArrayDeclarationExpressionModel;
import software.coley.sourcesolver.model.TypeModel;
import software.coley.sourcesolver.util.Range;

public class ArrayDeclarationMapper
implements Mapper<ArrayDeclarationExpressionModel, NewArrayTree> {
    @Override
    @Nonnull
    public ArrayDeclarationExpressionModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull NewArrayTree tree) {
        List<AnnotationExpressionModel> annotationModels = tree.getAnnotations().stream().map(anno -> (AnnotationExpressionModel)context.map(AnnotationUseMapper.class, anno)).toList();
        List dimensions = Objects.requireNonNullElse(tree.getDimensions(), Collections.emptyList());
        List initializers = Objects.requireNonNullElse(tree.getInitializers(), Collections.emptyList());
        List<AbstractExpressionModel> dimensionModels = dimensions.stream().map(e -> (AbstractExpressionModel)context.map(ExpressionMapper.class, e)).toList();
        List<AbstractExpressionModel> initializersModels = initializers.stream().map(e -> (AbstractExpressionModel)context.map(ExpressionMapper.class, e)).toList();
        TypeModel type = context.mapOr(TypeMapper.class, tree.getType(), TypeModel::newVar);
        return new ArrayDeclarationExpressionModel(Range.extractRange(table, tree), type, dimensionModels, initializersModels, annotationModels);
    }
}

