/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.CaseLabelTree;
import com.sun.source.tree.ConstantCaseLabelTree;
import com.sun.source.tree.PatternCaseLabelTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.PatternMapper;
import software.coley.sourcesolver.model.AbstractCaseLabelModel;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AbstractPatternModel;
import software.coley.sourcesolver.model.ConstCaseLabelModel;
import software.coley.sourcesolver.model.DefaultCaseLabelModel;
import software.coley.sourcesolver.model.PatternCaseLabelModel;
import software.coley.sourcesolver.util.Range;

public class CaseLabelMapper
implements Mapper<AbstractCaseLabelModel, CaseLabelTree> {
    @Override
    @Nonnull
    public AbstractCaseLabelModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull CaseLabelTree tree) {
        Range range = Range.extractRange(table, tree);
        if (tree instanceof ConstantCaseLabelTree) {
            ConstantCaseLabelTree constLabel = (ConstantCaseLabelTree)tree;
            AbstractExpressionModel constant = (AbstractExpressionModel)context.map(ExpressionMapper.class, constLabel.getConstantExpression());
            return new ConstCaseLabelModel(range, constant);
        }
        if (tree instanceof PatternCaseLabelTree) {
            PatternCaseLabelTree patternLabel = (PatternCaseLabelTree)tree;
            AbstractPatternModel patternModel = (AbstractPatternModel)context.map(PatternMapper.class, patternLabel.getPattern());
            return new PatternCaseLabelModel(range, patternModel);
        }
        return new DefaultCaseLabelModel(range);
    }
}

