/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import software.coley.sourcesolver.mapping.CaseLabelMapper;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.StatementMapper;
import software.coley.sourcesolver.model.AbstractCaseLabelModel;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AbstractStatementModel;
import software.coley.sourcesolver.model.CaseModel;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.util.Range;

public class CaseMapper
implements Mapper<CaseModel, CaseTree> {
    @Override
    @Nonnull
    public CaseModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull CaseTree tree) {
        List<AbstractCaseLabelModel> labels = tree.getLabels() == null ? Collections.emptyList() : tree.getLabels().stream().map(c -> (AbstractCaseLabelModel)context.map(CaseLabelMapper.class, c)).toList();
        List<AbstractExpressionModel> expressions = tree.getExpressions().stream().map(c -> (AbstractExpressionModel)context.map(ExpressionMapper.class, c)).toList();
        Model body = tree.getBody() == null ? null : this.mapBody(context, tree.getBody());
        List<AbstractStatementModel> statements = tree.getStatements() == null ? Collections.emptyList() : tree.getStatements().stream().map(c -> (AbstractStatementModel)context.map(StatementMapper.class, c)).toList();
        return new CaseModel(Range.extractRange(table, tree), labels, expressions, statements, body);
    }

    @Nonnull
    private Model mapBody(@Nonnull MappingContext context, @Nonnull Tree tree) {
        if (tree instanceof ExpressionTree) {
            ExpressionTree expression = (ExpressionTree)tree;
            return context.map(ExpressionMapper.class, expression);
        }
        if (tree instanceof StatementTree) {
            StatementTree statementMapper = (StatementTree)tree;
            return context.map(StatementMapper.class, statementMapper);
        }
        throw new IllegalStateException("Case body was not an expression or statement");
    }
}

