/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.IdentifierMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.TypeMapper;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.CastExpressionModel;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.UnknownExpressionModel;
import software.coley.sourcesolver.util.Range;

public class CastMapper
implements Mapper<CastExpressionModel, TypeCastTree> {
    @Override
    @Nonnull
    public CastExpressionModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull TypeCastTree tree) {
        Object type;
        Range range = Range.extractRange(table, tree);
        Tree typeTree = tree.getType();
        if (typeTree instanceof IdentifierTree) {
            IdentifierTree identifier = (IdentifierTree)typeTree;
            type = context.map(IdentifierMapper.class, identifier);
        } else if (typeTree instanceof PrimitiveTypeTree) {
            PrimitiveTypeTree primitive = (PrimitiveTypeTree)typeTree;
            type = context.map(TypeMapper.class, primitive);
        } else {
            type = new UnknownExpressionModel(Range.extractRange(table, typeTree), typeTree.toString());
        }
        AbstractExpressionModel expression = (AbstractExpressionModel)context.map(ExpressionMapper.class, tree.getExpression());
        return new CastExpressionModel(range, (Model)type, expression);
    }
}

