/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.List;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.StatementMapper;
import software.coley.sourcesolver.mapping.VariableMapper;
import software.coley.sourcesolver.model.LambdaExpressionModel;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.UnknownStatementModel;
import software.coley.sourcesolver.model.VariableModel;
import software.coley.sourcesolver.util.Range;

public class LambdaMapper
implements Mapper<LambdaExpressionModel, LambdaExpressionTree> {
    @Override
    @Nonnull
    public LambdaExpressionModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull LambdaExpressionTree tree) {
        Object body;
        LambdaExpressionModel.BodyKind kind;
        Tree tree2;
        Range range = Range.extractRange(table, tree);
        List<VariableModel> parameters = tree.getParameters().stream().map(p -> (VariableModel)context.map(VariableMapper.class, p)).toList();
        if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.STATEMENT && (tree2 = tree.getBody()) instanceof StatementTree) {
            StatementTree statementBody = (StatementTree)tree2;
            kind = LambdaExpressionModel.BodyKind.STATEMENT;
            body = context.map(StatementMapper.class, statementBody);
        } else if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION && (tree2 = tree.getBody()) instanceof ExpressionTree) {
            ExpressionTree expressionTree = (ExpressionTree)tree2;
            kind = LambdaExpressionModel.BodyKind.EXPRESSION;
            body = context.map(ExpressionMapper.class, expressionTree);
        } else {
            kind = LambdaExpressionModel.BodyKind.STATEMENT;
            body = new UnknownStatementModel(Range.extractRange(table, tree.getBody()), tree.getBody().toString());
        }
        return new LambdaExpressionModel(range, parameters, (Model)body, kind);
    }
}

