/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import software.coley.sourcesolver.mapping.AnnotationUseMapper;
import software.coley.sourcesolver.mapping.ArrayDeclarationMapper;
import software.coley.sourcesolver.mapping.BinaryMapper;
import software.coley.sourcesolver.mapping.BlockMapper;
import software.coley.sourcesolver.mapping.CaseLabelMapper;
import software.coley.sourcesolver.mapping.CaseMapper;
import software.coley.sourcesolver.mapping.CastMapper;
import software.coley.sourcesolver.mapping.CatchMapper;
import software.coley.sourcesolver.mapping.ClassMapper;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.IdentifierMapper;
import software.coley.sourcesolver.mapping.ImportMapper;
import software.coley.sourcesolver.mapping.InstanceofMapper;
import software.coley.sourcesolver.mapping.LambdaMapper;
import software.coley.sourcesolver.mapping.LiteralMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MemberReferenceMapper;
import software.coley.sourcesolver.mapping.MemberSelectMapper;
import software.coley.sourcesolver.mapping.MethodBodyMapper;
import software.coley.sourcesolver.mapping.MethodInvocationMapper;
import software.coley.sourcesolver.mapping.MethodMapper;
import software.coley.sourcesolver.mapping.ModifiersMapper;
import software.coley.sourcesolver.mapping.NameMapper;
import software.coley.sourcesolver.mapping.NewClassMapper;
import software.coley.sourcesolver.mapping.PatternMapper;
import software.coley.sourcesolver.mapping.StatementMapper;
import software.coley.sourcesolver.mapping.StaticInitializerMethodMapper;
import software.coley.sourcesolver.mapping.TryMapper;
import software.coley.sourcesolver.mapping.TypeArgumentsMapper;
import software.coley.sourcesolver.mapping.TypeMapper;
import software.coley.sourcesolver.mapping.TypeParameterMapper;
import software.coley.sourcesolver.mapping.UnaryMapper;
import software.coley.sourcesolver.mapping.VariableMapper;
import software.coley.sourcesolver.model.Model;

public class MappingContext {
    private static final Map<Class<?>, Supplier<Mapper<?, ?>>> mapperSuppliersByClass = new IdentityHashMap();
    private final EndPosTable table;
    private final String source;

    public MappingContext(@Nonnull EndPosTable table, @Nonnull String source) {
        this.table = table;
        this.source = source;
        this.initializeDefaultMappers();
    }

    @Nonnull
    public String getSource() {
        return this.source;
    }

    @Nonnull
    public EndPosTable getTable() {
        return this.table;
    }

    public <T extends Mapper<?, ?>> void setMapper(@Nonnull Class<T> mapperType, @Nonnull T mapperImplementation) {
        this.setMapperSupplier(mapperType, () -> mapperImplementation);
    }

    public <T extends Mapper<?, ?>> void setMapperSupplier(@Nonnull Class<T> mapperType, @Nonnull Supplier<T> mapperSupplier) {
        mapperSuppliersByClass.put(mapperType, mapperSupplier);
    }

    @Nonnull
    public <T> T getMapper(Class<T> mapperType) {
        Supplier<Mapper<?, ?>> mapperSupplier = mapperSuppliersByClass.get(mapperType);
        if (mapperSupplier == null) {
            throw new IllegalStateException("Unknown mapper type requested: " + String.valueOf(mapperType));
        }
        Mapper<?, ?> mapper = mapperSupplier.get();
        if (mapper == null) {
            throw new IllegalStateException("Mapper supplier for type was null: " + String.valueOf(mapperType));
        }
        return (T)mapper;
    }

    @Nonnull
    public <M extends Model, T extends Tree, X extends Mapper<M, T>> M map(@Nonnull Class<X> mapperType, @Nonnull T tree) {
        if (tree == null) {
            throw new IllegalStateException("Cannot map 'null' tree value to type " + mapperType.getSimpleName());
        }
        return ((Mapper)this.getMapper(mapperType)).map(this, this.table, tree);
    }

    @Nonnull
    public <M extends Model, T extends Tree, X extends Mapper<M, T>> M mapOr(@Nonnull Class<X> mapperType, @Nullable T tree, @Nonnull Supplier<M> defaultValueSupplier) {
        if (tree == null) {
            return (M)((Model)defaultValueSupplier.get());
        }
        return ((Mapper)this.getMapper(mapperType)).map(this, this.table, tree);
    }

    private void initializeDefaultMappers() {
        this.setMapper(AnnotationUseMapper.class, new AnnotationUseMapper());
        this.setMapper(ArrayDeclarationMapper.class, new ArrayDeclarationMapper());
        this.setMapper(BinaryMapper.class, new BinaryMapper());
        this.setMapper(BlockMapper.class, new BlockMapper());
        this.setMapper(CaseLabelMapper.class, new CaseLabelMapper());
        this.setMapper(CaseMapper.class, new CaseMapper());
        this.setMapper(CastMapper.class, new CastMapper());
        this.setMapper(CatchMapper.class, new CatchMapper());
        this.setMapper(ClassMapper.class, new ClassMapper());
        this.setMapper(ExpressionMapper.class, new ExpressionMapper());
        this.setMapper(IdentifierMapper.class, new IdentifierMapper());
        this.setMapper(ImportMapper.class, new ImportMapper());
        this.setMapper(InstanceofMapper.class, new InstanceofMapper());
        this.setMapper(LambdaMapper.class, new LambdaMapper());
        this.setMapper(LiteralMapper.class, new LiteralMapper());
        this.setMapper(MemberReferenceMapper.class, new MemberReferenceMapper());
        this.setMapper(MemberSelectMapper.class, new MemberSelectMapper());
        this.setMapper(MethodBodyMapper.class, new MethodBodyMapper());
        this.setMapper(MethodInvocationMapper.class, new MethodInvocationMapper());
        this.setMapper(MethodMapper.class, new MethodMapper());
        this.setMapper(ModifiersMapper.class, new ModifiersMapper());
        this.setMapper(NameMapper.class, new NameMapper());
        this.setMapper(NewClassMapper.class, new NewClassMapper());
        this.setMapper(PatternMapper.class, new PatternMapper());
        this.setMapper(StatementMapper.class, new StatementMapper());
        this.setMapper(StaticInitializerMethodMapper.class, new StaticInitializerMethodMapper());
        this.setMapper(TryMapper.class, new TryMapper());
        this.setMapper(TypeMapper.class, new TypeMapper());
        this.setMapper(TypeArgumentsMapper.class, new TypeArgumentsMapper());
        this.setMapper(TypeParameterMapper.class, new TypeParameterMapper());
        this.setMapper(UnaryMapper.class, new UnaryMapper());
        this.setMapper(VariableMapper.class, new VariableMapper());
    }
}

