/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.MemberReferenceTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.List;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.TypeArgumentsMapper;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.MethodReferenceExpressionModel;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.NameExpressionModel;
import software.coley.sourcesolver.util.Range;

public class MemberReferenceMapper
implements Mapper<MethodReferenceExpressionModel, MemberReferenceTree> {
    @Override
    @Nonnull
    public MethodReferenceExpressionModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull MemberReferenceTree tree) {
        Range range = Range.extractRange(table, tree);
        MethodReferenceExpressionModel.Mode mode = switch (tree.getMode()) {
            default -> throw new MatchException(null, null);
            case MemberReferenceTree.ReferenceMode.INVOKE -> MethodReferenceExpressionModel.Mode.INVOKE;
            case MemberReferenceTree.ReferenceMode.NEW -> MethodReferenceExpressionModel.Mode.NEW;
        };
        NameExpressionModel name = new NameExpressionModel(Range.UNKNOWN, tree.getName().toString());
        AbstractExpressionModel qualifier = (AbstractExpressionModel)context.map(ExpressionMapper.class, tree.getQualifierExpression());
        List<Model> typeArguments = ((TypeArgumentsMapper.Args)context.map(TypeArgumentsMapper.class, tree::getTypeArguments)).getArguments();
        return new MethodReferenceExpressionModel(range, mode, qualifier, name, typeArguments);
    }
}

