/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.TryTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.List;
import software.coley.sourcesolver.mapping.BlockMapper;
import software.coley.sourcesolver.mapping.CatchMapper;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.StatementMapper;
import software.coley.sourcesolver.model.BlockStatementModel;
import software.coley.sourcesolver.model.CatchModel;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.TryStatementModel;
import software.coley.sourcesolver.util.Range;

public class TryMapper
implements Mapper<TryStatementModel, TryTree> {
    @Override
    @Nonnull
    public TryStatementModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull TryTree tree) {
        BlockStatementModel block = (BlockStatementModel)context.map(BlockMapper.class, tree.getBlock());
        BlockStatementModel finallyBlock = tree.getFinallyBlock() == null ? null : (BlockStatementModel)context.map(BlockMapper.class, tree.getFinallyBlock());
        List<Model> resources = tree.getResources().stream().map(t -> {
            Object model;
            if (t instanceof ExpressionTree) {
                ExpressionTree e = (ExpressionTree)t;
                model = context.map(ExpressionMapper.class, e);
            } else if (t instanceof StatementTree) {
                StatementTree s = (StatementTree)t;
                model = context.map(StatementMapper.class, s);
            } else {
                throw new IllegalStateException("Unsupported catch resource AST node: " + t.getClass().getSimpleName());
            }
            return model;
        }).toList();
        List<CatchModel> catches = tree.getCatches().stream().map(c -> (CatchModel)context.map(CatchMapper.class, c)).toList();
        return new TryStatementModel(Range.extractRange(table, tree), block, finallyBlock, resources, catches);
    }
}

