/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.WildcardTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.MemberSelectMapper;
import software.coley.sourcesolver.mapping.NameMapper;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.NameExpressionModel;
import software.coley.sourcesolver.model.TypeModel;
import software.coley.sourcesolver.util.Range;

public class TypeMapper
implements Mapper<TypeModel, Tree> {
    @Override
    @Nonnull
    public TypeModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull Tree tree) {
        Range range = Range.extractRange(table, tree);
        Tree tree2 = tree;
        Objects.requireNonNull(tree2);
        Tree tree3 = tree2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveTypeTree.class, IdentifierTree.class, ErroneousTree.class, MemberSelectTree.class, ArrayTypeTree.class, ParameterizedTypeTree.class, WildcardTree.class, UnionTypeTree.class}, (Object)tree3, n)) {
            case 0 -> {
                PrimitiveTypeTree primitive = (PrimitiveTypeTree)tree3;
                yield new TypeModel.Primitive(range, (Model)context.map(NameMapper.class, primitive));
            }
            case 1 -> {
                IdentifierTree identifier = (IdentifierTree)tree3;
                yield new TypeModel.NamedObject(range, (Model)context.map(NameMapper.class, identifier));
            }
            case 2 -> {
                ErroneousTree erroneous = (ErroneousTree)tree3;
                yield new TypeModel.NamedObject(range, (Model)context.map(NameMapper.class, erroneous));
            }
            case 3 -> {
                MemberSelectTree select = (MemberSelectTree)tree3;
                yield new TypeModel.NamedObject(range, (Model)context.map(MemberSelectMapper.class, select));
            }
            case 4 -> {
                ArrayTypeTree arrayType = (ArrayTypeTree)tree3;
                TypeModel elementType = this.map(context, table, arrayType.getType());
                yield new TypeModel.Array(range, (Model)elementType);
            }
            case 5 -> {
                ParameterizedTypeTree parameterizedType = (ParameterizedTypeTree)tree3;
                TypeModel identifier = this.map(context, table, parameterizedType.getType());
                List<TypeModel> typeParameters = parameterizedType.getTypeArguments().stream().map(t -> this.map(context, table, (Tree)t)).toList();
                yield new TypeModel.Parameterized(range, (Model)identifier, typeParameters);
            }
            case 6 -> {
                WildcardTree wildcardTree = (WildcardTree)tree3;
                NameExpressionModel identifier = (NameExpressionModel)context.map(NameMapper.class, wildcardTree);
                TypeModel boundModel = wildcardTree.getBound() == null ? null : this.map(context, table, wildcardTree.getBound());
                yield new TypeModel.Wildcard(range, (Model)identifier, (Model)boundModel);
            }
            case 7 -> {
                UnionTypeTree unionTypeTree = (UnionTypeTree)tree3;
                List<TypeModel> alternatives = unionTypeTree.getTypeAlternatives().stream().map(t -> this.map(context, table, (Tree)t)).toList();
                yield new TypeModel.Union(range, alternatives.getFirst(), alternatives.subList(1, alternatives.size()));
            }
            default -> throw new IllegalArgumentException("Unsupported tree for TypeModel: " + tree.getClass().getSimpleName());
        };
    }
}

