/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.Tree;
import com.sun.source.tree.UnaryTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.UnaryExpressionModel;
import software.coley.sourcesolver.util.Range;

public class UnaryMapper
implements Mapper<UnaryExpressionModel, UnaryTree> {
    @Override
    @Nonnull
    public UnaryExpressionModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull UnaryTree tree) {
        Range range = Range.extractRange(table, tree);
        AbstractExpressionModel expression = (AbstractExpressionModel)context.map(ExpressionMapper.class, tree.getExpression());
        UnaryExpressionModel.Operator operator = switch (tree.getKind()) {
            case Tree.Kind.POSTFIX_INCREMENT -> UnaryExpressionModel.Operator.POST_INCREMENT;
            case Tree.Kind.POSTFIX_DECREMENT -> UnaryExpressionModel.Operator.POST_DECREMENT;
            case Tree.Kind.PREFIX_INCREMENT -> UnaryExpressionModel.Operator.PRE_INCREMENT;
            case Tree.Kind.PREFIX_DECREMENT -> UnaryExpressionModel.Operator.PRE_DECREMENT;
            case Tree.Kind.UNARY_PLUS -> UnaryExpressionModel.Operator.POSITIVE;
            case Tree.Kind.UNARY_MINUS -> UnaryExpressionModel.Operator.NEGATIVE;
            case Tree.Kind.LOGICAL_COMPLEMENT -> UnaryExpressionModel.Operator.NOT;
            case Tree.Kind.BITWISE_COMPLEMENT -> UnaryExpressionModel.Operator.BIT_NOT;
            default -> UnaryExpressionModel.Operator.UNKNOWN;
        };
        return new UnaryExpressionModel(range, expression, operator);
    }
}

