/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import java.util.List;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AnnotatedModel;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.TypeModel;
import software.coley.sourcesolver.util.Range;

public class ArrayDeclarationExpressionModel
extends AbstractExpressionModel
implements AnnotatedModel {
    private final TypeModel type;
    private final List<AbstractExpressionModel> dimensions;
    private final List<AbstractExpressionModel> initializers;
    private final List<AnnotationExpressionModel> annotations;

    public ArrayDeclarationExpressionModel(@Nonnull Range range, @Nonnull TypeModel type, @Nonnull List<AbstractExpressionModel> dimensions, @Nonnull List<AbstractExpressionModel> initializers, @Nonnull List<AnnotationExpressionModel> annotations) {
        super(range, ChildSupplier.of((Model)type), ChildSupplier.of(dimensions), ChildSupplier.of(initializers), ChildSupplier.of(annotations));
        this.type = type;
        this.dimensions = dimensions;
        this.initializers = initializers;
        this.annotations = annotations;
    }

    @Nonnull
    public TypeModel getType() {
        return this.type;
    }

    @Nonnull
    public List<AbstractExpressionModel> getDimensions() {
        return this.dimensions;
    }

    @Nonnull
    public List<AbstractExpressionModel> getInitializers() {
        return this.initializers;
    }

    @Override
    @Nonnull
    public List<AnnotationExpressionModel> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayDeclarationExpressionModel that = (ArrayDeclarationExpressionModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.dimensions.equals(that.dimensions)) {
            return false;
        }
        if (!this.initializers.equals(that.initializers)) {
            return false;
        }
        return this.annotations.equals(that.annotations);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + this.dimensions.hashCode();
        result = 31 * result + this.initializers.hashCode();
        result = 31 * result + this.annotations.hashCode();
        return result;
    }

    public String toString() {
        return "new " + String.valueOf(this.type) + "[]".repeat(this.dimensions.size());
    }
}

