/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.util.Range;

public class BinaryExpressionModel
extends AbstractExpressionModel {
    private final AbstractExpressionModel left;
    private final AbstractExpressionModel right;
    private final Operator operator;

    public BinaryExpressionModel(@Nonnull Range range, @Nonnull AbstractExpressionModel left, @Nonnull AbstractExpressionModel right, @Nonnull Operator operator) {
        super(range, left, right);
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    @Nonnull
    public AbstractExpressionModel getLeft() {
        return this.left;
    }

    @Nonnull
    public AbstractExpressionModel getRight() {
        return this.right;
    }

    @Nonnull
    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryExpressionModel that = (BinaryExpressionModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.left.equals(that.left)) {
            return false;
        }
        if (!this.right.equals(that.right)) {
            return false;
        }
        return this.operator == that.operator;
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.left.hashCode();
        result = 31 * result + this.right.hashCode();
        result = 31 * result + this.operator.hashCode();
        return result;
    }

    public String toString() {
        return String.valueOf(this.left) + " " + String.valueOf((Object)this.operator) + " " + String.valueOf(this.right);
    }

    public static enum Operator {
        PLUS("+"),
        MINUS("-"),
        MULTIPLY("*"),
        DIVIDE("/"),
        REMAINDER("%"),
        EQUALS("=="),
        NOT_EQUALS("!="),
        BIT_OR("|"),
        BIT_AND("&"),
        BIT_XOR("^"),
        CONDITIONAL_OR("||"),
        CONDITIONAL_AND("&&"),
        SHIFT_LEFT("<<"),
        SHIFT_RIGHT(">>"),
        SHIFT_RIGHT_UNSIGNED(">>>"),
        RELATION_LESS("<"),
        RELATION_GREATER(">"),
        RELATION_LESS_EQUAL("<="),
        RELATION_GREATER_EQUAL(">="),
        RELATION_INSTANCEOF("instanceof"),
        UNKNOWN("<binop>");

        private final String text;

        private Operator(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

