/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractCaseLabelModel;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AbstractModel;
import software.coley.sourcesolver.model.AbstractStatementModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.util.Range;

public class CaseModel
extends AbstractModel {
    private final List<AbstractCaseLabelModel> labels;
    private final List<AbstractExpressionModel> expressions;
    private final List<AbstractStatementModel> statements;
    private final Model body;

    public CaseModel(@Nonnull Range range, @Nonnull List<AbstractCaseLabelModel> labels, @Nonnull List<AbstractExpressionModel> expressions, @Nonnull List<AbstractStatementModel> statements, @Nullable Model body) {
        super(range, ChildSupplier.of(labels), ChildSupplier.of(expressions), ChildSupplier.of(statements), ChildSupplier.of(body));
        this.labels = labels;
        this.expressions = expressions;
        this.statements = statements;
        this.body = body;
    }

    @Nonnull
    public List<AbstractCaseLabelModel> getLabels() {
        return this.labels;
    }

    @Nonnull
    public List<AbstractExpressionModel> getExpressions() {
        return this.expressions;
    }

    @Nonnull
    public List<AbstractStatementModel> getStatements() {
        return this.statements;
    }

    @Nullable
    public Model getBody() {
        return this.body;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseModel caseModel = (CaseModel)o;
        if (!this.labels.equals(caseModel.labels)) {
            return false;
        }
        if (!this.expressions.equals(caseModel.expressions)) {
            return false;
        }
        if (!this.statements.equals(caseModel.statements)) {
            return false;
        }
        return Objects.equals(this.body, caseModel.body);
    }

    @Override
    public int hashCode() {
        int result = this.labels.hashCode();
        result = 31 * result + this.expressions.hashCode();
        result = 31 * result + this.statements.hashCode();
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        return result;
    }

    public String toString() {
        String expressions = this.expressions.stream().map(Object::toString).collect(Collectors.joining(", "));
        if (this.body != null) {
            return "case " + expressions + " -> " + String.valueOf(this.body);
        }
        return "case " + expressions + ":\n    " + this.statements.stream().map(Object::toString).collect(Collectors.joining("\n    "));
    }
}

