/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import software.coley.sourcesolver.model.Model;

public interface ChildSupplier {
    @Nonnull
    public static ChildSupplier of(final @Nullable Model model) {
        if (model == null) {
            return new ChildSupplier(){

                @Override
                public boolean isSingle() {
                    return false;
                }

                @Override
                @Nonnull
                public Model getSingle() {
                    throw new UnsupportedOperationException();
                }

                @Override
                @Nonnull
                public Collection<? extends Model> getMultiple() {
                    return Collections.emptyList();
                }
            };
        }
        return new ChildSupplier(){

            @Override
            public boolean isSingle() {
                return true;
            }

            @Override
            @Nonnull
            public Model getSingle() {
                return model;
            }

            @Override
            @Nonnull
            public Collection<? extends Model> getMultiple() {
                return Collections.emptyList();
            }
        };
    }

    @Nonnull
    public static ChildSupplier of(final @Nonnull Collection<? extends Model> models) {
        return new ChildSupplier(){

            @Override
            public boolean isSingle() {
                return false;
            }

            @Override
            @Nonnull
            public Model getSingle() {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nonnull
            public Collection<? extends Model> getMultiple() {
                return models;
            }
        };
    }

    @Nonnull
    public static ChildSupplier of(final Model ... models) {
        return new ChildSupplier(){

            @Override
            public boolean isSingle() {
                return false;
            }

            @Override
            @Nonnull
            public Model getSingle() {
                throw new UnsupportedOperationException();
            }

            @Override
            @Nonnull
            public Collection<? extends Model> getMultiple() {
                return Arrays.asList(models);
            }
        };
    }

    public boolean isSingle();

    @Nonnull
    public Model getSingle();

    @Nonnull
    public Collection<? extends Model> getMultiple();
}

