/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AbstractStatementModel;
import software.coley.sourcesolver.util.Range;

public class ForLoopStatementModel
extends AbstractStatementModel {
    private final List<AbstractStatementModel> initializerStatements;
    private final List<AbstractStatementModel> updateStatements;
    private final AbstractExpressionModel condition;
    private final AbstractStatementModel statement;

    public ForLoopStatementModel(@Nonnull Range range, @Nonnull List<AbstractStatementModel> initializerStatements, @Nonnull List<AbstractStatementModel> updateStatements, @Nonnull AbstractExpressionModel condition, @Nonnull AbstractStatementModel statement) {
        super(range, condition, statement);
        this.initializerStatements = initializerStatements;
        this.updateStatements = updateStatements;
        this.condition = condition;
        this.statement = statement;
    }

    @Nonnull
    public List<AbstractStatementModel> getInitializerStatements() {
        return this.initializerStatements;
    }

    @Nonnull
    public List<AbstractStatementModel> getUpdateStatements() {
        return this.updateStatements;
    }

    @Nonnull
    public AbstractExpressionModel getCondition() {
        return this.condition;
    }

    @Nonnull
    public AbstractStatementModel getStatement() {
        return this.statement;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForLoopStatementModel that = (ForLoopStatementModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.initializerStatements.equals(that.initializerStatements)) {
            return false;
        }
        if (!this.updateStatements.equals(that.updateStatements)) {
            return false;
        }
        if (!this.condition.equals(that.condition)) {
            return false;
        }
        return this.statement.equals(that.statement);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.initializerStatements.hashCode();
        result = 31 * result + this.updateStatements.hashCode();
        result = 31 * result + this.condition.hashCode();
        result = 31 * result + this.statement.hashCode();
        return result;
    }

    public String toString() {
        String initStr = this.initializerStatements.stream().map(Object::toString).collect(Collectors.joining("; "));
        String updateStr = this.updateStatements.stream().map(Object::toString).collect(Collectors.joining("; "));
        return "for (" + initStr + "; " + String.valueOf(this.condition) + "; " + updateStr + ") { " + String.valueOf(this.statement) + " }";
    }
}

