/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.NamedModel;
import software.coley.sourcesolver.util.Range;

public class ImplementsModel
extends AbstractModel {
    public static final ImplementsModel EMPTY = new ImplementsModel(Range.UNKNOWN, Collections.emptyList());
    private final List<NamedModel> implementedClassNames;

    public ImplementsModel(@Nonnull Range range, @Nonnull List<NamedModel> implementedClassNames) {
        super(range, ChildSupplier.of(implementedClassNames));
        this.implementedClassNames = Collections.unmodifiableList(implementedClassNames);
    }

    @Nonnull
    public List<NamedModel> getImplementedClassNames() {
        return this.implementedClassNames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImplementsModel that = (ImplementsModel)o;
        return this.implementedClassNames.equals(that.implementedClassNames) && this.getRange().equals(that.getRange());
    }

    @Override
    public int hashCode() {
        return this.implementedClassNames.hashCode() + 31 * this.getRange().hashCode();
    }

    public String toString() {
        if (this.implementedClassNames.isEmpty()) {
            return "";
        }
        return "implements " + this.implementedClassNames.stream().map(NamedModel::getName).collect(Collectors.joining(", "));
    }
}

