/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.util.Range;

public class LiteralExpressionModel
extends AbstractExpressionModel {
    private final Kind kind;
    private final Object content;

    public LiteralExpressionModel(@Nonnull Range range, @Nonnull Kind kind, @Nullable Object content) {
        super(range);
        this.kind = kind;
        this.content = content;
    }

    @Nonnull
    public Kind getKind() {
        return this.kind;
    }

    @Nullable
    public Object getContent() {
        return this.content;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteralExpressionModel that = (LiteralExpressionModel)o;
        if (this.kind != that.kind) {
            return false;
        }
        return Objects.equals(this.content, that.content);
    }

    @Override
    public int hashCode() {
        int result = this.kind.hashCode();
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        return result;
    }

    public String toString() {
        String contentString = Objects.toString(this.content);
        if (this.kind == Kind.STRING) {
            return "\"" + contentString + "\"";
        }
        return contentString;
    }

    public static enum Kind {
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        CHAR,
        STRING,
        NULL,
        VOID,
        ERROR;

    }
}

