/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.util.Range;

public class MethodInvocationExpressionModel
extends AbstractExpressionModel {
    private final List<Model> typeArguments;
    private final AbstractExpressionModel methodSelect;
    private final List<AbstractExpressionModel> arguments;

    public MethodInvocationExpressionModel(@Nonnull Range range, @Nonnull List<Model> typeArguments, @Nonnull AbstractExpressionModel methodSelect, @Nonnull List<AbstractExpressionModel> arguments) {
        super(range, ChildSupplier.of(typeArguments), ChildSupplier.of((Model)methodSelect), ChildSupplier.of(arguments));
        this.typeArguments = typeArguments;
        this.methodSelect = methodSelect;
        this.arguments = arguments;
    }

    @Nonnull
    public List<Model> getTypeArguments() {
        return this.typeArguments;
    }

    @Nonnull
    public AbstractExpressionModel getMethodSelect() {
        return this.methodSelect;
    }

    @Nonnull
    public List<AbstractExpressionModel> getArguments() {
        return this.arguments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodInvocationExpressionModel that = (MethodInvocationExpressionModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.typeArguments.equals(that.typeArguments)) {
            return false;
        }
        if (!this.methodSelect.equals(that.methodSelect)) {
            return false;
        }
        return this.arguments.equals(that.arguments);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.typeArguments.hashCode();
        result = 31 * result + this.methodSelect.hashCode();
        result = 31 * result + this.arguments.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.typeArguments != null && !this.typeArguments.isEmpty()) {
            sb.append('<').append(this.typeArguments.stream().map(Object::toString).collect(Collectors.joining(", "))).append('>');
        }
        sb.append(this.methodSelect.toString());
        sb.append('(').append(this.arguments.stream().map(Object::toString).collect(Collectors.joining(", "))).append(')');
        return sb.toString();
    }
}

