/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AbstractModel;
import software.coley.sourcesolver.model.AnnotatedModel;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.MethodBodyModel;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.ModifiersModel;
import software.coley.sourcesolver.model.NameExpressionModel;
import software.coley.sourcesolver.model.NameHoldingModel;
import software.coley.sourcesolver.model.TypeModel;
import software.coley.sourcesolver.model.TypeParameterModel;
import software.coley.sourcesolver.model.VariableModel;
import software.coley.sourcesolver.util.Range;

public class MethodModel
extends AbstractModel
implements AnnotatedModel,
NameHoldingModel {
    private final String name;
    private final ModifiersModel modifiers;
    private final List<TypeParameterModel> typeParameters;
    private final TypeModel returnType;
    private final List<VariableModel> parameters;
    private final Model defaultValue;
    private final List<AbstractExpressionModel> thrownTypes;
    private final List<AnnotationExpressionModel> annotations;
    private final MethodBodyModel methodBody;

    public MethodModel(@Nonnull Range range, @Nonnull String name, @Nonnull ModifiersModel modifiers, @Nonnull List<TypeParameterModel> typeParameters, @Nonnull TypeModel returnType, @Nonnull List<VariableModel> parameters, @Nullable Model defaultValue, @Nonnull List<AbstractExpressionModel> thrownTypes, @Nonnull List<AnnotationExpressionModel> annotations, @Nullable MethodBodyModel methodBody) {
        super(range, ChildSupplier.of((Model)modifiers), ChildSupplier.of(typeParameters), ChildSupplier.of((Model)returnType), ChildSupplier.of(parameters), ChildSupplier.of(defaultValue), ChildSupplier.of(thrownTypes), ChildSupplier.of(annotations), ChildSupplier.of((Model)methodBody));
        this.name = name;
        this.modifiers = modifiers;
        this.typeParameters = typeParameters;
        this.returnType = returnType;
        this.parameters = parameters;
        this.defaultValue = defaultValue;
        this.thrownTypes = thrownTypes;
        this.annotations = annotations;
        this.methodBody = methodBody;
    }

    public boolean isStaticInitializer() {
        return "<clinit>".equals(this.name);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public NameExpressionModel getNameModel() {
        return null;
    }

    @Nonnull
    public ModifiersModel getModifiers() {
        return this.modifiers;
    }

    @Nonnull
    public List<TypeParameterModel> getTypeParameters() {
        return this.typeParameters;
    }

    @Nonnull
    public TypeModel getReturnType() {
        return this.returnType;
    }

    @Nonnull
    public List<VariableModel> getParameters() {
        return this.parameters;
    }

    @Nullable
    public Model getDefaultValue() {
        return this.defaultValue;
    }

    @Nonnull
    public List<AbstractExpressionModel> getThrownTypes() {
        return this.thrownTypes;
    }

    @Override
    @Nonnull
    public List<AnnotationExpressionModel> getAnnotations() {
        return this.annotations;
    }

    @Nullable
    public MethodBodyModel getMethodBody() {
        return this.methodBody;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodModel that = (MethodModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.modifiers.equals(that.modifiers)) {
            return false;
        }
        if (!this.typeParameters.equals(that.typeParameters)) {
            return false;
        }
        if (!this.returnType.equals(that.returnType)) {
            return false;
        }
        if (!this.parameters.equals(that.parameters)) {
            return false;
        }
        if (!Objects.equals(this.defaultValue, that.defaultValue)) {
            return false;
        }
        if (!this.thrownTypes.equals(that.thrownTypes)) {
            return false;
        }
        if (!Objects.equals(this.methodBody, that.methodBody)) {
            return false;
        }
        return this.annotations.equals(that.annotations);
    }

    @Override
    public int hashCode() {
        int result = this.getReturnType().hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.modifiers.hashCode();
        result = 31 * result + this.typeParameters.hashCode();
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + this.parameters.hashCode();
        result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        result = 31 * result + this.thrownTypes.hashCode();
        result = 31 * result + this.annotations.hashCode();
        result = 31 * result + (this.methodBody != null ? this.methodBody.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isStaticInitializer()) {
            sb.append("static");
        } else {
            String args = this.parameters.stream().map(VariableModel::toString).collect(Collectors.joining(" "));
            if (!this.modifiers.getModifiers().isEmpty()) {
                sb.append(this.modifiers).append(' ');
            }
            sb.append(this.returnType.toString()).append(' ').append(this.name).append('(').append(args).append(')');
        }
        if (this.methodBody != null) {
            sb.append(" ").append(this.methodBody);
        } else {
            sb.append(';');
        }
        return sb.toString();
    }
}

