/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.NameExpressionModel;
import software.coley.sourcesolver.model.NameHoldingModel;
import software.coley.sourcesolver.util.Range;

public class MethodReferenceExpressionModel
extends AbstractExpressionModel
implements NameHoldingModel {
    private final AbstractExpressionModel qualifier;
    private final NameExpressionModel name;
    private final List<Model> typeArguments;
    private final Mode mode;

    public MethodReferenceExpressionModel(@Nonnull Range range, @Nonnull Mode mode, @Nonnull AbstractExpressionModel qualifier, @Nonnull NameExpressionModel name, @Nonnull List<Model> typeArguments) {
        super(range, ChildSupplier.of((Model)qualifier), ChildSupplier.of((Model)name), ChildSupplier.of(typeArguments));
        this.mode = mode;
        this.qualifier = qualifier;
        this.name = name;
        this.typeArguments = typeArguments;
    }

    @Nonnull
    public Mode getMode() {
        return this.mode;
    }

    @Nonnull
    public AbstractExpressionModel getQualifier() {
        return this.qualifier;
    }

    @Override
    @Nullable
    public NameExpressionModel getNameModel() {
        return this.name;
    }

    @Nonnull
    public List<Model> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodReferenceExpressionModel that = (MethodReferenceExpressionModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.mode.equals((Object)that.mode)) {
            return false;
        }
        if (!this.typeArguments.equals(that.typeArguments)) {
            return false;
        }
        if (!this.qualifier.equals(that.qualifier)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.mode.hashCode();
        result = 31 * result + this.typeArguments.hashCode();
        result = 31 * result + this.qualifier.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.typeArguments != null && !this.typeArguments.isEmpty()) {
            sb.append('<').append(this.typeArguments.stream().map(Object::toString).collect(Collectors.joining(", "))).append('>');
        }
        sb.append(this.qualifier).append("::").append(this.name);
        return sb.toString();
    }

    public static enum Mode {
        INVOKE,
        NEW;

    }
}

