/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.TreeSet;
import software.coley.sourcesolver.model.AbstractModel;
import software.coley.sourcesolver.util.Range;

public class ModifiersModel
extends AbstractModel {
    public static final ModifiersModel EMPTY = new ModifiersModel(Range.UNKNOWN, (Collection<String>)Collections.emptySet());
    private static final List<String> ORDER = List.of("public", "protected", "private", "abstract", "static", "final", "open", "mandated", "synthetic", "synchronized", "native", "transient", "volatile", "strictfp", "interface", "annotation-interface", "enum", "module");
    private final NavigableSet<String> modifiers;

    public ModifiersModel(@Nonnull Range range, @Nonnull Collection<String> modifiers) {
        super(range);
        this.modifiers = ModifiersModel.sortModifiers(modifiers);
    }

    @Nonnull
    private static NavigableSet<String> sortModifiers(@Nonnull Collection<String> modifiers) {
        TreeSet<String> set = new TreeSet<String>((o1, o2) -> {
            int i2;
            int i1 = ORDER.indexOf(o1);
            int cmp = Integer.compare(i1, i2 = ORDER.indexOf(o2));
            if (cmp == 0) {
                cmp = o1.compareToIgnoreCase((String)o2);
            }
            return cmp;
        });
        set.addAll(modifiers);
        return set;
    }

    @Nonnull
    public NavigableSet<String> getModifiers() {
        return this.modifiers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifiersModel that = (ModifiersModel)o;
        return Objects.equals(this.modifiers, that.modifiers);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + (this.modifiers != null ? this.modifiers.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.join((CharSequence)" ", this.modifiers);
    }
}

