/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.ClassModel;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.NamedModel;
import software.coley.sourcesolver.util.Range;

public class NewClassExpressionModel
extends AbstractExpressionModel
implements NamedModel {
    private final AbstractExpressionModel enclosingExpression;
    private final List<Model> typeArguments;
    private final AbstractExpressionModel identifier;
    private final List<AbstractExpressionModel> arguments;
    private final ClassModel body;

    public NewClassExpressionModel(@Nonnull Range range, @Nullable AbstractExpressionModel enclosingExpression, @Nonnull List<Model> typeArguments, @Nonnull AbstractExpressionModel identifier, @Nonnull List<AbstractExpressionModel> arguments, @Nullable ClassModel body) {
        super(range, ChildSupplier.of((Model)enclosingExpression), ChildSupplier.of(typeArguments), ChildSupplier.of((Model)identifier), ChildSupplier.of(arguments), ChildSupplier.of((Model)body));
        this.enclosingExpression = enclosingExpression;
        this.typeArguments = typeArguments;
        this.identifier = identifier;
        this.arguments = arguments;
        this.body = body;
    }

    @Nullable
    public AbstractExpressionModel getEnclosingExpression() {
        return this.enclosingExpression;
    }

    @Nonnull
    public List<Model> getTypeArguments() {
        return this.typeArguments;
    }

    @Nonnull
    public AbstractExpressionModel getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    public List<AbstractExpressionModel> getArguments() {
        return this.arguments;
    }

    @Nullable
    public ClassModel getBody() {
        return this.body;
    }

    @Override
    @Nonnull
    public String getName() {
        String string;
        AbstractExpressionModel abstractExpressionModel = this.getIdentifier();
        if (abstractExpressionModel instanceof NamedModel) {
            NamedModel named = (NamedModel)((Object)abstractExpressionModel);
            string = named.getName();
        } else {
            string = this.getIdentifier().toString();
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewClassExpressionModel that = (NewClassExpressionModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!Objects.equals(this.enclosingExpression, that.enclosingExpression)) {
            return false;
        }
        if (!this.typeArguments.equals(that.typeArguments)) {
            return false;
        }
        if (!this.identifier.equals(that.identifier)) {
            return false;
        }
        if (!this.arguments.equals(that.arguments)) {
            return false;
        }
        return Objects.equals(this.body, that.body);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + (this.enclosingExpression != null ? this.enclosingExpression.hashCode() : 0);
        result = 31 * result + this.typeArguments.hashCode();
        result = 31 * result + this.identifier.hashCode();
        result = 31 * result + this.arguments.hashCode();
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.enclosingExpression != null) {
            sb.append(this.enclosingExpression).append('.');
        }
        sb.append("new ").append(this.identifier);
        if (this.typeArguments != null && !this.typeArguments.isEmpty()) {
            sb.append('<').append(this.typeArguments.stream().map(Object::toString).collect(Collectors.joining(", "))).append('>');
        }
        sb.append('(').append(this.arguments.stream().map(Object::toString).collect(Collectors.joining(", "))).append(')');
        if (this.body != null) {
            sb.append(this.body);
        }
        return sb.toString();
    }
}

