/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.CaseModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.util.Range;

public class SwitchExpressionModel
extends AbstractExpressionModel {
    private final AbstractExpressionModel expression;
    private final List<CaseModel> cases;

    public SwitchExpressionModel(@Nonnull Range range, @Nonnull AbstractExpressionModel expression, @Nonnull List<CaseModel> cases) {
        super(range, ChildSupplier.of((Model)expression), ChildSupplier.of(cases));
        this.expression = expression;
        this.cases = cases;
    }

    @Nonnull
    public AbstractExpressionModel getExpression() {
        return this.expression;
    }

    @Nonnull
    public List<CaseModel> getCases() {
        return this.cases;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwitchExpressionModel that = (SwitchExpressionModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.expression.equals(that.expression)) {
            return false;
        }
        return this.cases.equals(that.cases);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.expression.hashCode();
        result = 31 * result + this.cases.hashCode();
        return result;
    }

    public String toString() {
        return "switch " + String.valueOf(this.expression) + ") {\n" + this.cases.stream().map(CaseModel::toString).collect(Collectors.joining("\n")) + "\n}";
    }
}

