/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.type.TypeKind;
import software.coley.sourcesolver.model.AbstractModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.model.NameExpressionModel;
import software.coley.sourcesolver.model.NamedModel;
import software.coley.sourcesolver.util.Range;

public abstract class TypeModel
extends AbstractModel {
    private final Model identifier;

    protected TypeModel(@Nonnull Range range, @Nonnull Model identifier) {
        super(range, identifier);
        this.identifier = identifier;
    }

    protected TypeModel(@Nonnull Range range, @Nonnull Model identifier, @Nonnull Collection<? extends Model> additionalChildren) {
        super(range, ChildSupplier.of(identifier), ChildSupplier.of(additionalChildren));
        this.identifier = identifier;
    }

    @Nonnull
    public Model getIdentifier() {
        return this.identifier;
    }

    @Nonnull
    public abstract Kind getKind();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeModel typeModel = (TypeModel)o;
        if (!this.identifier.equals(typeModel.identifier)) {
            return false;
        }
        return this.getKind() == typeModel.getKind();
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.identifier.hashCode();
        result = 31 * result + this.getKind().hashCode();
        return result;
    }

    public String toString() {
        return this.identifier.toString();
    }

    @Nonnull
    public static TypeModel newVar() {
        return new Var();
    }

    public static enum Kind {
        PRIMITIVE,
        OBJECT,
        PARAMETERIZED,
        UNION,
        WILDCARD,
        VAR,
        ARRAY;

    }

    public static class Var
    extends TypeModel {
        public Var() {
            super(Range.UNKNOWN, (Model)new NameExpressionModel(Range.UNKNOWN, "var"));
        }

        @Override
        @Nonnull
        public Kind getKind() {
            return Kind.VAR;
        }
    }

    public static class Wildcard
    extends TypeModel {
        private final Model boundModel;

        public Wildcard(@Nonnull Range range, @Nonnull Model identifierModel, @Nullable Model boundModel) {
            super(range, identifierModel, Collections.singletonList(boundModel));
            this.boundModel = boundModel;
        }

        @Nullable
        public Model getBound() {
            return this.boundModel;
        }

        @Override
        @Nonnull
        public Kind getKind() {
            return Kind.WILDCARD;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Wildcard wildcard = (Wildcard)o;
            return Objects.equals(this.boundModel, wildcard.boundModel);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.boundModel != null ? this.boundModel.hashCode() : 0);
            return result;
        }
    }

    public static class Union
    extends TypeModel {
        private final List<TypeModel> allTypes;

        public Union(@Nonnull Range range, @Nonnull TypeModel identifier, @Nonnull Collection<? extends TypeModel> additionalChildren) {
            super(range, (Model)identifier, additionalChildren);
            ArrayList<? extends TypeModel> all = new ArrayList<TypeModel>(additionalChildren.size() + 1);
            all.addAll(additionalChildren);
            all.addFirst(identifier);
            this.allTypes = Collections.unmodifiableList(all);
        }

        @Nonnull
        public List<TypeModel> getAllTypes() {
            return this.allTypes;
        }

        @Override
        @Nonnull
        public Kind getKind() {
            return Kind.UNION;
        }
    }

    public static class Parameterized
    extends TypeModel
    implements NamedModel {
        private final List<Model> typeArguments;

        public Parameterized(@Nonnull Range range, @Nonnull Model identifierModel, @Nonnull List<? extends Model> typeArguments) {
            super(range, identifierModel, typeArguments);
            this.typeArguments = Collections.unmodifiableList(typeArguments);
        }

        @Nonnull
        public List<Model> getTypeArguments() {
            return this.typeArguments;
        }

        @Override
        @Nonnull
        public Kind getKind() {
            return Kind.PARAMETERIZED;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.getIdentifier().toString();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Parameterized that = (Parameterized)o;
            return this.typeArguments.equals(that.typeArguments);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.typeArguments.hashCode();
            return result;
        }

        @Override
        public String toString() {
            return super.toString() + "<" + this.typeArguments.stream().map(Object::toString).collect(Collectors.joining(", ")) + ">";
        }
    }

    public static class Array
    extends TypeModel {
        private int dimensions = -1;

        public Array(@Nonnull Range range, @Nonnull Model elementModel) {
            super(range, elementModel);
        }

        public int getDimensions() {
            if (this.dimensions == -1) {
                Model model = this.getIdentifier();
                if (model instanceof Array) {
                    Array sub = (Array)model;
                    this.dimensions = 1 + sub.getDimensions();
                } else {
                    this.dimensions = 1;
                }
            }
            return this.dimensions;
        }

        @Nonnull
        public Model getRootModel() {
            Model root = this.getIdentifier();
            while (root instanceof Array) {
                Array array = (Array)root;
                root = array.getRootModel();
            }
            return root;
        }

        @Override
        @Nonnull
        public Kind getKind() {
            return Kind.ARRAY;
        }

        @Override
        public String toString() {
            return String.valueOf(this.getRootModel()) + "[]".repeat(this.getDimensions());
        }
    }

    public static class NamedObject
    extends TypeModel
    implements NamedModel {
        public NamedObject(@Nonnull Range range, @Nonnull Model identifierModel) {
            super(range, identifierModel);
        }

        @Override
        @Nonnull
        public Kind getKind() {
            return Kind.OBJECT;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.getIdentifier().toString();
        }
    }

    public static class Primitive
    extends TypeModel
    implements NamedModel {
        private TypeKind primitiveKind;

        public Primitive(@Nonnull Range range, @Nonnull Model identifierModel) {
            super(range, identifierModel);
        }

        @Override
        @Nonnull
        public Kind getKind() {
            return Kind.PRIMITIVE;
        }

        @Nonnull
        public TypeKind getPrimitiveKind() {
            if (this.primitiveKind == null) {
                String identifier;
                this.primitiveKind = switch (identifier = this.getIdentifier().toString()) {
                    case "boolean" -> TypeKind.BOOLEAN;
                    case "byte" -> TypeKind.BYTE;
                    case "short" -> TypeKind.SHORT;
                    case "int" -> TypeKind.INT;
                    case "long" -> TypeKind.LONG;
                    case "char" -> TypeKind.CHAR;
                    case "float" -> TypeKind.FLOAT;
                    case "double" -> TypeKind.DOUBLE;
                    case "void" -> TypeKind.VOID;
                    default -> TypeKind.ERROR;
                };
            }
            return this.primitiveKind;
        }

        @Override
        @Nonnull
        public String getName() {
            return this.getIdentifier().toString();
        }
    }
}

