/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.model;

import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import software.coley.sourcesolver.model.AbstractModel;
import software.coley.sourcesolver.model.AnnotatedModel;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.ChildSupplier;
import software.coley.sourcesolver.model.Model;
import software.coley.sourcesolver.util.Range;

public class TypeParameterModel
extends AbstractModel
implements AnnotatedModel {
    private final String name;
    private final List<Model> bounds;
    private final List<AnnotationExpressionModel> annotations;

    public TypeParameterModel(@Nonnull Range range, @Nonnull String name, @Nonnull List<Model> bounds, @Nonnull List<AnnotationExpressionModel> annotations) {
        super(range, ChildSupplier.of(bounds), ChildSupplier.of(annotations));
        this.name = name;
        this.bounds = bounds;
        this.annotations = annotations;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public List<Model> getBounds() {
        return this.bounds;
    }

    @Override
    @Nonnull
    public List<AnnotationExpressionModel> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeParameterModel that = (TypeParameterModel)o;
        if (!this.getRange().equals(that.getRange())) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.bounds.equals(that.bounds)) {
            return false;
        }
        return this.annotations.equals(that.annotations);
    }

    @Override
    public int hashCode() {
        int result = this.getRange().hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.bounds.hashCode();
        result = 31 * result + this.annotations.hashCode();
        return result;
    }

    public String toString() {
        if (this.bounds.isEmpty()) {
            return this.name;
        }
        return this.name + " extends " + this.bounds.stream().map(Object::toString).collect(Collectors.joining(", "));
    }
}

